/*
Navicat MySQL Data Transfer

Source Server         : fangke
Source Server Version : 50726
Source Host           : localhost:3306
Source Database       : fangke

Target Server Type    : MYSQL
Target Server Version : 50726
File Encoding         : 65001

Date: 2026-02-06 21:46:52
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for admin_users
-- ----------------------------
DROP TABLE IF EXISTS `admin_users`;
CREATE TABLE `admin_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of admin_users
-- ----------------------------
INSERT INTO `admin_users` VALUES ('1', 'admin', '$2y$10$EJ64ugc3YEnGH2jaM06XCO68igbTx4LpkcfVPnzoJHRy8Wm8h0Hti', '系统管理员', 'admin@example.com', '2026-02-06 21:29:17', 'active', '2024-12-22 13:10:01');

-- ----------------------------
-- Table structure for cache
-- ----------------------------
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(191) NOT NULL COMMENT '缓存键名',
  `value` text NOT NULL COMMENT '缓存值',
  `expire_time` int(11) NOT NULL COMMENT '过期时间',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统缓存表';

-- ----------------------------
-- Records of cache
-- ----------------------------
INSERT INTO `cache` VALUES ('access_token', '{\"access_token\":\"87_v_tdZNCc5VvJmTEaJtWa_VXCgIQuU1iESI4rAHVvdIF0K9mkPbvZFgHkhaZ4HTafKa1jt0B-MIbcdcLuKKM86i5VNpxMMlO9Gi-ZJpGCjSEWN_V9jJXR98W_NBMDCDjAJAKJK\",\"expires_in\":7200}', '1734784022');
INSERT INTO `cache` VALUES ('jsapi_ticket', '{\"errcode\":0,\"errmsg\":\"ok\",\"ticket\":\"O3SMpm8bG7kJnF36aXbe8whE4mXDwUBjreS3yqUlyx5WN7Ir4OTA_mqWFSQZ5lmFqdynWf4KSyE3eaZep1OyBw\",\"expires_in\":7200}', '1734784022');
INSERT INTO `cache` VALUES ('wechat_access_token', '92_KNBBEaWD6scpGe0KfZGJ6i_rSgPAtQljmspgyU7wuuekvuphoejR9nkqi2J78NEQwv5dJh_ExZvPtJ1KZQ4lVqCoQCoxVhk5td4RBC31EShVaoqDxT5WOy9NCqwORKfAEAZCV', '1747018611');
INSERT INTO `cache` VALUES ('wechat_jsapi_ticket', 'O3SMpm8bG7kJnF36aXbe87g-WPJNEflkpSmLLfqn2XICIG1gw5ifomP33oOnwmilONo5UJsqHgIBVb6z23fK_g', '1747018611');

-- ----------------------------
-- Table structure for faq
-- ----------------------------
DROP TABLE IF EXISTS `faq`;
CREATE TABLE `faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `category` (`category`(191)),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of faq
-- ----------------------------
INSERT INTO `faq` VALUES ('1', '1', '1', '11', '0', '1', null, '2025-06-07 15:32:24', '2025-06-07 15:32:38');
INSERT INTO `faq` VALUES ('2', '如何注册账号？', '您可以通过以下方式注册账号：\n1. 点击首页右上角的\"注册\"按钮\n2. 使用微信扫码登录\n3. 填写手机号获取验证码注册\n\n注册完成后即可使用系统所有基础功能。', '账号相关', '1', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('3', '忘记密码怎么办？', '如果您忘记了密码，可以通过以下步骤重置：\n1. 点击登录页面的\"忘记密码\"\n2. 输入注册时使用的手机号\n3. 获取验证码并输入\n4. 设置新密码\n\n重置密码后，请使用新密码登录。', '账号相关', '2', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('4', '如何开通VIP会员？', '开通VIP会员的步骤如下：\n1. 点击首页的\"开通VIP\"按钮\n2. 选择适合您的VIP套餐\n3. 选择支付方式完成支付\n4. 支付成功后自动开通VIP权限\n\n开通VIP后可以享受更多高级功能。', 'VIP相关', '1', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('5', 'VIP会员有哪些特权？', 'VIP会员可以享受以下特权：\n1. 无限次查看访客记录\n2. 查看访客详细资料\n3. 导出访客数据\n4. 优先客服支持\n5. 更多高级功能\n\n具体特权以实际开通的套餐为准。', 'VIP相关', '2', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('6', '如何查看访客记录？', '查看访客记录的步骤：\n1. 登录您的账号\n2. 在首页可以看到最近的访客记录\n3. 点击\"查看更多\"可以查看历史记录\n4. VIP用户可以使用高级筛选功能\n\n注意：普通用户有查看次数限制。', '功能使用', '1', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('7', '如何导出访客数据？', '导出访客数据的步骤：\n1. 登录您的账号\n2. 进入访客记录页面\n3. 点击\"导出数据\"按钮\n4. 选择导出格式（Excel/CSV）\n5. 等待下载完成\n\n注意：导出功能仅限VIP用户使用。', '功能使用', '2', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('8', '支持哪些支付方式？', '目前系统支持以下支付方式：\n1. 微信支付\n2. 支付宝\n3. 银行卡支付\n\n支付过程中如遇到问题，请联系客服处理。', '支付相关', '1', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('9', '支付后没有开通成功怎么办？', '如果支付后没有立即开通成功，请按以下步骤处理：\n1. 等待1-2分钟，系统可能正在处理\n2. 刷新页面查看状态\n3. 如果仍未开通，请保留支付凭证\n4. 联系客服处理\n\n客服会协助您核实支付情况并处理。', '支付相关', '2', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('10', '如何联系客服？', '您可以通过以下方式联系客服：\n1. 点击页面右下角的\"在线客服\"按钮\n2. 发送邮件至客服邮箱\n3. 在工作时间拨打客服电话\n\n客服工作时间为：周一至周五 9:00-18:00', '其他问题', '1', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');
INSERT INTO `faq` VALUES ('11', '系统使用遇到问题怎么办？', '如果使用系统时遇到问题：\n1. 查看常见问题解答\n2. 检查网络连接是否正常\n3. 清除浏览器缓存后重试\n4. 如果问题仍然存在，请联系客服\n\n我们会尽快为您解决问题。', '其他问题', '2', '1', null, '2025-06-07 15:34:23', '2025-06-07 15:34:23');

-- ----------------------------
-- Table structure for feedback
-- ----------------------------
DROP TABLE IF EXISTS `feedback`;
CREATE TABLE `feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending','processing','resolved','closed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `admin_reply` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of feedback
-- ----------------------------
INSERT INTO `feedback` VALUES ('1', '365', 'suggestion', '1', '1', null, 'pending', null, '2025-06-07 15:50:15', '2025-06-07 15:50:15');

-- ----------------------------
-- Table structure for posts
-- ----------------------------
DROP TABLE IF EXISTS `posts`;
CREATE TABLE `posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '发布者ID',
  `content` text NOT NULL COMMENT '动态内容',
  `image` varchar(255) DEFAULT NULL COMMENT '图片URL',
  `share_code` varchar(32) NOT NULL COMMENT '分享码',
  `view_count` int(11) NOT NULL DEFAULT '0' COMMENT '查看次数',
  `status` enum('active','deleted') NOT NULL DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `share_status` enum('draft','shared') NOT NULL DEFAULT 'draft' COMMENT '分享状态：draft=未分享，shared=已分享',
  `first_share_time` datetime DEFAULT NULL COMMENT '首次分享时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `share_code` (`share_code`),
  KEY `idx_share_status` (`share_status`),
  CONSTRAINT `posts_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COMMENT='动态表';

-- ----------------------------
-- Records of posts
-- ----------------------------

-- ----------------------------
-- Table structure for system_config
-- ----------------------------
DROP TABLE IF EXISTS `system_config`;
CREATE TABLE `system_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(50) NOT NULL COMMENT '配置键名',
  `value` text NOT NULL COMMENT '配置值',
  `description` varchar(255) DEFAULT NULL COMMENT '配置说明',
  `type` enum('text','textarea','number','switch') NOT NULL DEFAULT 'text' COMMENT '配置类型',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COMMENT='系统配置表';

-- ----------------------------
-- Records of system_config
-- ----------------------------
INSERT INTO `system_config` VALUES ('1', 'wechat_appid', 'wxdb905ed143482a80', '微信公众号AppID', 'text', '2024-12-22 07:44:48', '2026-02-06 15:31:23');
INSERT INTO `system_config` VALUES ('2', 'wechat_secret', '885993b40e1687455102dae1b53891e9', '微信公众号Secret', 'text', '2024-12-22 07:44:48', '2026-02-06 15:31:23');
INSERT INTO `system_config` VALUES ('3', 'site_url', 'https://ggdao.net/', '站点URL', 'text', '2024-12-22 07:44:48', '2026-02-06 21:30:43');
INSERT INTO `system_config` VALUES ('4', 'site_name', '朋友圈访客', '站点名称', 'text', '2024-12-22 07:44:48', '2026-02-06 15:31:23');
INSERT INTO `system_config` VALUES ('5', 'share_default_image', '/assets/images/share-logo.png', '默认分享图片', 'text', '2024-12-22 07:44:48', '2024-12-22 07:44:48');
INSERT INTO `system_config` VALUES ('6', 'epay_url', 'https://shnhbh.jconwd.cn/', '易支付接口地址', 'text', '2025-03-05 08:00:00', '2026-02-06 15:32:16');
INSERT INTO `system_config` VALUES ('7', 'epay_pid', '1000', '易支付商户ID', 'text', '2025-03-05 08:00:00', '2026-02-06 15:32:16');
INSERT INTO `system_config` VALUES ('8', 'epay_key', '1jXrLycI777vRRlMZSqrMJR1R2srM7lR', '易支付商户密钥', 'text', '2025-03-05 08:00:00', '2026-02-06 15:32:16');
INSERT INTO `system_config` VALUES ('9', 'epay_notify_url', '{site_url}/vip/notify.php', '支付异步通知地址', 'text', '2025-03-05 08:00:00', '2025-03-05 08:00:00');
INSERT INTO `system_config` VALUES ('10', 'epay_return_url', '{site_url}/vip/return.php', '支付同步跳转地址', 'text', '2025-03-05 08:00:00', '2025-03-05 08:00:00');
INSERT INTO `system_config` VALUES ('11', 'card_purchase_url', '', '卡密购买链接', 'text', '2025-03-05 16:43:22', '2025-04-01 12:08:10');
INSERT INTO `system_config` VALUES ('12', 'card_purchase_description', '没有卡密？点击购买卡密即可购买', '卡密购买说明', 'textarea', '2025-03-05 16:43:22', '2025-03-05 23:51:45');
INSERT INTO `system_config` VALUES ('13', 'card_purchase_contact', '卡密专属客服微信:P10-24Y', '购买联系方式', 'text', '2025-03-05 16:43:22', '2025-04-16 12:30:05');
INSERT INTO `system_config` VALUES ('14', 'card_purchase_status', '1', '卡密购买功能开关', 'switch', '2025-03-05 16:43:22', '2025-04-01 18:53:31');
INSERT INTO `system_config` VALUES ('15', 'enable_vip_pay', '1', 'VIP支付购买开关：1=开启，0=关闭', 'text', '2025-03-05 18:01:20', '2025-03-10 12:41:24');
INSERT INTO `system_config` VALUES ('16', 'enable_vip_card', '0', 'VIP卡密购买开关：1=开启，0=关闭', 'text', '2025-03-05 18:01:20', '2025-05-06 22:57:19');
INSERT INTO `system_config` VALUES ('17', 'wechat_oauth_api', 'https://ggdao.net/', '公众号无限回调登录接口', 'text', '2026-02-06 15:27:21', '2026-02-06 21:31:15');

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(64) DEFAULT NULL COMMENT '微信openid',
  `username` varchar(50) DEFAULT NULL COMMENT '用户名',
  `password` varchar(255) DEFAULT NULL COMMENT '密码',
  `nickname` varchar(50) NOT NULL COMMENT '微信昵称',
  `avatar` varchar(255) NOT NULL COMMENT '头像URL',
  `role` enum('user','admin') NOT NULL DEFAULT 'user' COMMENT '用户角色',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_login` timestamp NULL DEFAULT NULL,
  `share_count` int(11) DEFAULT '0',
  `is_unlocked` tinyint(1) DEFAULT '0',
  `unlock_time` datetime DEFAULT NULL,
  `source` enum('direct','share') NOT NULL DEFAULT 'direct' COMMENT '用户来源：direct=直接访问，share=分享裂变',
  `share_from_post_id` int(11) DEFAULT NULL COMMENT '如果是通过分享来的，记录是哪个动态',
  `share_from_user_id` int(11) DEFAULT NULL COMMENT '如果是通过分享来的，记录是哪个用户分享的',
  `vip_level` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'VIP等级：0=普通用户，1=VIP会员',
  `vip_expire_time` datetime DEFAULT NULL COMMENT 'VIP过期时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`),
  UNIQUE KEY `username` (`username`),
  KEY `idx_source` (`source`),
  KEY `idx_share_from_post` (`share_from_post_id`),
  KEY `idx_share_from_user` (`share_from_user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=497 DEFAULT CHARSET=utf8mb4 COMMENT='用户表';

-- ----------------------------
-- Records of users
-- ----------------------------

-- ----------------------------
-- Table structure for vip_cards
-- ----------------------------
DROP TABLE IF EXISTS `vip_cards`;
CREATE TABLE `vip_cards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `card_no` varchar(32) NOT NULL COMMENT '卡密号码',
  `days` int(11) NOT NULL COMMENT 'VIP天数',
  `status` enum('unused','used','invalid') NOT NULL DEFAULT 'unused' COMMENT '状态：unused=未使用,used=已使用,invalid=已作废',
  `batch_no` varchar(32) DEFAULT NULL COMMENT '生成批次号',
  `used_user_id` int(11) DEFAULT NULL COMMENT '使用用户ID',
  `used_time` datetime DEFAULT NULL COMMENT '使用时间',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `expire_time` datetime DEFAULT NULL COMMENT '过期时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_no` (`card_no`),
  KEY `batch_no` (`batch_no`),
  KEY `used_user_id` (`used_user_id`),
  CONSTRAINT `vip_cards_ibfk_1` FOREIGN KEY (`used_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COMMENT='VIP卡密表';

-- ----------------------------
-- Records of vip_cards
-- ----------------------------
INSERT INTO `vip_cards` VALUES ('1', 'USGF-IP2P-64ZT-WJG7', '9999', 'used', '202503060009029192', null, '2025-03-06 03:11:09', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('2', 'JUIY-IQCP-8G2E-36BJ', '9999', 'used', '202503060009029192', null, '2025-03-06 10:58:27', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('3', 'L43E-WGQ0-Q4ZL-37PB', '9999', 'used', '202503060009029192', null, '2025-03-06 11:03:22', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('4', 'JI4S-NL6Y-G9NF-6CBJ', '9999', 'used', '202503060009029192', null, '2025-03-06 14:35:34', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('5', 'XC1R-L8QB-O63Y-KQJK', '9999', 'used', '202503060009029192', null, '2025-03-06 16:08:21', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('6', 'VAOQ-0ZOV-LSJ6-H914', '9999', 'used', '202503060009029192', null, '2025-03-06 17:20:03', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('7', 'FSOG-L7GJ-EF32-1SQO', '9999', 'used', '202503060009029192', null, '2025-03-06 19:14:02', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('8', 'RKYK-3ZVJ-KABC-JL2I', '9999', 'used', '202503060009029192', null, '2025-03-06 20:34:13', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('9', 'EL7F-SEZG-5QZC-3S3Y', '9999', 'used', '202503060009029192', null, '2025-03-06 22:02:49', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('10', 'VHP5-A8N5-5WV0-OARR', '9999', 'used', '202503060009029192', null, '2025-03-06 22:41:19', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('11', '7KGG-0XWL-3U7A-OQO5', '9999', 'used', '202503060009029192', null, '2025-03-06 23:49:40', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('12', 'U3CL-EM7P-CZSU-J7S9', '9999', 'used', '202503060009029192', null, '2025-03-07 03:26:34', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('13', 'XVGH-4JJ5-60B2-DR09', '9999', 'used', '202503060009029192', null, '2025-03-07 05:10:04', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('14', 'W906-GREN-1ILB-3YFM', '9999', 'used', '202503060009029192', null, '2025-03-07 10:03:41', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('15', 'TF8H-LVTJ-YSHP-CRCM', '9999', 'used', '202503060009029192', null, '2025-03-07 23:40:58', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('16', 'CQ0I-OMU9-U912-ENV5', '9999', 'used', '202503060009029192', null, '2025-03-07 23:48:29', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('17', 'CKF5-PZ83-X3ZR-WXI0', '9999', 'used', '202503060009029192', null, '2025-03-08 00:01:33', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('18', '45J2-Y7SD-U2NP-UICL', '9999', 'used', '202503060009029192', null, '2025-03-08 20:20:15', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('19', 'NN6R-7F8Q-W3JY-VTDD', '9999', 'used', '202503060009029192', null, '2025-03-09 12:23:34', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('20', 'QF0W-C8X1-ITB9-BPOA', '9999', 'used', '202503060009029192', null, '2025-03-09 23:45:05', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('21', 'U9HE-SSEA-E03Q-3TUP', '9999', 'used', '202503060009029192', null, '2025-03-10 10:36:22', '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('22', '1XIU-0QBX-VOZ1-RHRQ', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('23', 'EIHO-WGJ3-WXU2-LT7O', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('24', 'WGEA-J6LV-N165-VK5S', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('25', 'QHSW-P60N-N6VS-U0EY', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('26', 'RYY2-N1PB-KSV9-6TPW', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('27', 'EE1B-XJU8-Q8T4-5E2W', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('28', 'EKVA-XLS8-3RD9-6RL9', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('29', 'E9LZ-ADX9-QT9G-46YN', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('30', '1BJD-CSOG-17OT-0TUL', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('31', 'IO8U-O7HT-H24S-4HLJ', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('32', 'OMEZ-IFOW-0NYB-L699', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('33', '1GDU-76XG-WA8S-O8QN', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('34', 'E974-T1OQ-TE9V-SVVY', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('35', 'V6VI-GOJ0-O542-NFEX', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('36', 'I6S0-WGJX-70Z2-NZTT', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('37', '2LD1-42TJ-HVIO-P4HJ', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('38', 'RGV1-G3M0-8PNV-Q3JB', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('39', 'K33F-TLI3-ID85-IGBS', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('40', 'EN90-EUCG-TCY1-2RCY', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('41', 'JWZ8-8GRB-J6UX-U7GU', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('42', 'MYOS-3ZD2-B1XZ-61RP', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('43', 'UN49-RUGS-RXPC-E4S8', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('44', 'JBWH-9AKA-IV1F-SB4Q', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('45', 'U403-ZADH-TMBM-BFZ4', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('46', 'T09P-AUE2-03NY-XO24', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('47', 'NRRE-4GC5-CVML-KOK6', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('48', 'LBJR-OEC6-ZLQI-6ZAV', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('49', 'W4VQ-SER0-19GP-W5YW', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('50', '1PW2-NH6G-KAJA-0YUR', '9999', 'unused', '202503060009029192', null, null, '2025-03-06 00:09:02', null);
INSERT INTO `vip_cards` VALUES ('51', '2PML-162P-47DM-SUGG', '7', 'used', '202503060010268502', null, '2025-03-06 01:49:09', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('52', 'LAA5-1T3V-WKFP-T01O', '7', 'used', '202503060010268502', null, '2025-03-06 14:08:55', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('53', '4C0V-2IJQ-PAVN-JW44', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('54', 'XU61-HRLG-6JWW-MJBK', '7', 'used', '202503060010268502', null, '2025-03-07 10:45:26', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('55', 'OVO8-PAM5-EPFF-0SKV', '7', 'used', '202503060010268502', null, '2025-03-07 23:01:13', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('56', 'DPJ4-1HBR-QKG2-LGL7', '7', 'used', '202503060010268502', null, '2025-03-10 11:05:18', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('57', 'RSC9-JZ8E-86CT-2IES', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('58', 'FVYV-177D-CJD2-AK8Z', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('59', 'ZTMO-3L41-UOCY-3HEX', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('60', 'B16P-8K8O-OYFU-QOBZ', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('61', 'UEWK-X851-SY2P-BXD0', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('62', 'NES8-YYSI-IMDI-ZJF0', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('63', 'O5CL-I85T-0DPW-6QPZ', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('64', 'WG72-PNHA-MY6K-Q9ME', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('65', 'LHJ6-YK3S-JY6D-9UVF', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('66', 'O5WG-SJU1-RO22-FSNU', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('67', '3ATK-H4FJ-Q9FP-8XRV', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('68', 'TN75-VVR3-2DYO-WA6I', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('69', 'UOHT-OSR6-RHIT-512T', '7', 'unused', '202503060010268502', null, null, '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('70', '9JRQ-NUYO-D8ZF-CYEF', '7', 'used', '202503060010268502', null, '2025-04-01 19:05:31', '2025-03-06 00:10:26', null);
INSERT INTO `vip_cards` VALUES ('71', '4MFX-CT4R-LH2M-H3IV', '7', 'used', '202503060011318879', null, '2025-03-06 00:12:09', '2025-03-06 00:11:31', null);

-- ----------------------------
-- Table structure for vip_orders
-- ----------------------------
DROP TABLE IF EXISTS `vip_orders`;
CREATE TABLE `vip_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `order_no` varchar(32) NOT NULL COMMENT '订单号',
  `trade_no` varchar(64) DEFAULT NULL COMMENT '支付平台交易号',
  `amount` decimal(10,2) NOT NULL COMMENT '订单金额',
  `days` int(11) NOT NULL COMMENT 'VIP天数',
  `status` enum('pending','paid','cancelled') NOT NULL DEFAULT 'pending' COMMENT '订单状态',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `paid_at` datetime DEFAULT NULL COMMENT '支付时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_no` (`order_no`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COMMENT='VIP订单表';

-- ----------------------------
-- Records of vip_orders
-- ----------------------------
INSERT INTO `vip_orders` VALUES ('1', '1', '202503051616269442', null, '9.80', '3', 'pending', '2025-03-05 16:16:26', null);
INSERT INTO `vip_orders` VALUES ('2', '1', '202503051616585092', null, '9.80', '3', 'pending', '2025-03-05 16:16:58', null);
INSERT INTO `vip_orders` VALUES ('3', '1', '202503051625269246', null, '9.80', '3', 'pending', '2025-03-05 16:25:26', null);
INSERT INTO `vip_orders` VALUES ('4', '1', '202503051625474773', null, '9.80', '3', 'pending', '2025-03-05 16:25:47', null);
INSERT INTO `vip_orders` VALUES ('5', '1', '202503051644231520', null, '9.80', '3', 'pending', '2025-03-05 16:44:23', null);
INSERT INTO `vip_orders` VALUES ('6', '1', '202503051646151722', null, '19.90', '7', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('7', '1', '202503051646155404', null, '9.80', '3', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('8', '1', '202503051646154540', null, '19.90', '7', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('9', '1', '202503051646157098', null, '9.80', '3', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('10', '1', '202503051646152160', null, '19.90', '7', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('11', '1', '202503051646156962', null, '9.80', '3', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('12', '1', '202503051646156640', null, '9.80', '3', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('13', '1', '202503051646151426', null, '29.90', '30', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('14', '1', '202503051646151025', null, '29.90', '30', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('15', '1', '202503051646157215', null, '9.80', '3', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('16', '1', '202503051646159006', null, '19.90', '7', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('17', '1', '202503051646155211', null, '29.90', '30', 'pending', '2025-03-05 16:46:15', null);
INSERT INTO `vip_orders` VALUES ('18', '1', '202503051647018276', null, '9.80', '3', 'pending', '2025-03-05 16:47:01', null);
INSERT INTO `vip_orders` VALUES ('19', '1', '202503051651124991', null, '9.80', '3', 'pending', '2025-03-05 16:51:12', null);
INSERT INTO `vip_orders` VALUES ('20', '1', '202503051651173455', null, '9.80', '3', 'pending', '2025-03-05 16:51:17', null);
INSERT INTO `vip_orders` VALUES ('21', '1', '202503051652388394', null, '9.80', '3', 'pending', '2025-03-05 16:52:38', null);
INSERT INTO `vip_orders` VALUES ('22', '1', '202503051655336938', null, '0.10', '3', 'pending', '2025-03-05 16:55:33', null);
INSERT INTO `vip_orders` VALUES ('23', '1', '202503051658071446', null, '0.10', '3', 'pending', '2025-03-05 16:58:07', null);
INSERT INTO `vip_orders` VALUES ('24', '1', '202503051659368938', null, '0.10', '3', 'pending', '2025-03-05 16:59:36', null);
INSERT INTO `vip_orders` VALUES ('25', '1', '202503051700518176', null, '0.10', '3', 'pending', '2025-03-05 17:00:51', null);
INSERT INTO `vip_orders` VALUES ('26', '1', '202503051701409255', null, '0.10', '3', 'pending', '2025-03-05 17:01:40', null);
INSERT INTO `vip_orders` VALUES ('27', '1', '202503051702524540', null, '0.10', '3', 'pending', '2025-03-05 17:02:52', null);
INSERT INTO `vip_orders` VALUES ('28', '1', '202503051715302309', null, '0.10', '3', 'pending', '2025-03-05 17:15:30', null);
INSERT INTO `vip_orders` VALUES ('29', '1', '202503051718443165', null, '0.10', '3', 'pending', '2025-03-05 17:18:44', null);
INSERT INTO `vip_orders` VALUES ('30', '1', '202503051719379492', null, '0.10', '3', 'pending', '2025-03-05 17:19:37', null);
INSERT INTO `vip_orders` VALUES ('31', '1', '202503051719536161', null, '0.10', '3', 'pending', '2025-03-05 17:19:53', null);
INSERT INTO `vip_orders` VALUES ('32', '14', '202503051733386254', null, '0.10', '3', 'pending', '2025-03-05 17:33:38', null);
INSERT INTO `vip_orders` VALUES ('33', '1', '202503051737033357', null, '0.10', '3', 'pending', '2025-03-05 17:37:03', null);
INSERT INTO `vip_orders` VALUES ('34', '1', '202503051739316829', null, '0.10', '3', 'pending', '2025-03-05 17:39:31', null);
INSERT INTO `vip_orders` VALUES ('35', '14', '202503051740264575', null, '0.10', '3', 'pending', '2025-03-05 17:40:26', null);
INSERT INTO `vip_orders` VALUES ('36', '14', '202503051741137189', null, '0.10', '3', 'pending', '2025-03-05 17:41:13', null);
INSERT INTO `vip_orders` VALUES ('37', '1', '202503051743482406', 'Y2025030517434884345', '0.10', '3', 'paid', '2025-03-05 17:43:48', '2025-03-05 17:43:56');
INSERT INTO `vip_orders` VALUES ('38', '1', '202503051744408906', 'Y2025030517444131118', '0.10', '3', 'paid', '2025-03-05 17:44:40', '2025-03-05 17:44:48');
INSERT INTO `vip_orders` VALUES ('39', '15', '202503051849552138', null, '0.10', '3', 'pending', '2025-03-05 18:49:55', null);
INSERT INTO `vip_orders` VALUES ('40', '1', '202503101242156904', null, '0.10', '3', 'pending', '2025-03-10 12:42:15', null);
INSERT INTO `vip_orders` VALUES ('41', '1', '202503101242364356', null, '1.00', '3', 'pending', '2025-03-10 12:42:36', null);
INSERT INTO `vip_orders` VALUES ('42', '1', '202503101244102009', null, '1.00', '3', 'pending', '2025-03-10 12:44:10', null);
INSERT INTO `vip_orders` VALUES ('43', '1', '202503101244365628', '2025031012443688484', '1.00', '3', 'paid', '2025-03-10 12:44:36', '2025-03-10 12:44:48');
INSERT INTO `vip_orders` VALUES ('44', '364', '202504011856338283', null, '5.80', '3', 'pending', '2025-04-01 18:56:33', null);
INSERT INTO `vip_orders` VALUES ('45', '365', '202504161241289496', null, '5.80', '3', 'pending', '2025-04-16 12:41:28', null);
INSERT INTO `vip_orders` VALUES ('46', '365', '202504172152407667', null, '5.80', '3', 'pending', '2025-04-17 21:52:40', null);
INSERT INTO `vip_orders` VALUES ('47', '365', '202504172153061464', null, '8.80', '30', 'pending', '2025-04-17 21:53:06', null);
INSERT INTO `vip_orders` VALUES ('48', '488', '202504181135313835', null, '9.90', '90', 'pending', '2025-04-18 11:35:31', null);
INSERT INTO `vip_orders` VALUES ('49', '365', '202505062256424788', null, '5.80', '3', 'pending', '2025-05-06 22:56:42', null);
INSERT INTO `vip_orders` VALUES ('50', '365', '202505062300011549', null, '5.80', '3', 'pending', '2025-05-06 23:00:01', null);
INSERT INTO `vip_orders` VALUES ('51', '365', '202505062300509722', 'Y2025050623005063238', '1.00', '3', 'paid', '2025-05-06 23:00:50', '2025-05-06 23:01:03');

-- ----------------------------
-- Table structure for vip_plans
-- ----------------------------
DROP TABLE IF EXISTS `vip_plans`;
CREATE TABLE `vip_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '套餐名称',
  `days` int(11) NOT NULL COMMENT '天数',
  `price` decimal(10,2) NOT NULL COMMENT '价格',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active' COMMENT '状态',
  `sort_order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='VIP套餐表';

-- ----------------------------
-- Records of vip_plans
-- ----------------------------
INSERT INTO `vip_plans` VALUES ('1', '七天体验', '3', '1.00', '超值体验套餐', 'active', '1', '2025-03-05 14:53:28', '2025-05-06 23:00:37');
INSERT INTO `vip_plans` VALUES ('3', '月卡会员', '30', '8.80', '人气热销套餐', 'active', '3', '2025-03-05 14:53:28', '2025-03-10 12:45:54');
INSERT INTO `vip_plans` VALUES ('4', '年卡会员', '90', '9.90', '优惠套餐', 'active', '4', '2025-03-05 14:53:28', '2025-03-10 12:45:44');

-- ----------------------------
-- Table structure for visitors
-- ----------------------------
DROP TABLE IF EXISTS `visitors`;
CREATE TABLE `visitors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL COMMENT '动态ID',
  `visitor_id` int(11) NOT NULL COMMENT '访客用户ID',
  `ip_address` varchar(45) DEFAULT NULL COMMENT '访问IP',
  `user_agent` varchar(255) DEFAULT NULL COMMENT '浏览器信息',
  `visited_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `visitor_id` (`visitor_id`),
  CONSTRAINT `visitors_post_id_fk` FOREIGN KEY (`post_id`) REFERENCES `posts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `visitors_visitor_id_fk` FOREIGN KEY (`visitor_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COMMENT='访问记录表';

-- ----------------------------
-- Records of visitors
-- ----------------------------
