<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Admin.php';

// 设置响应类型
header('Content-Type: application/json');

// 验证管理员权限
if (!Admin::isAdmin()) {
    echo json_encode(['success' => false, 'message' => '无权限']);
    exit;
}

// 验证参数
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => '参数错误']);
    exit;
}

try {
    $admin = new Admin();
    $success = $admin->deletePost($_GET['id']);
    
    if ($success) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => '删除失败']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 