<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Admin.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();

// 初始化数据库连接
$db = Database::getInstance();

// 获取筛选参数
$status = isset($_GET['status']) ? $_GET['status'] : '';
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';

// 构建查询条件
$where = [];
$params = [];

if ($status) {
    $where[] = "vo.status = ?";
    $params[] = $status;
}

if ($start_date) {
    $where[] = "vo.created_at >= ?";
    $params[] = $start_date . ' 00:00:00';
}

if ($end_date) {
    $where[] = "vo.created_at <= ?";
    $params[] = $end_date . ' 23:59:59';
}

if ($search) {
    $where[] = "(vo.order_no LIKE ? OR u.nickname LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$where_clause = $where ? "WHERE " . implode(" AND ", $where) : "";

// 获取订单列表
$sql = "SELECT vo.*, u.nickname 
        FROM vip_orders vo 
        LEFT JOIN users u ON vo.user_id = u.id 
        $where_clause 
        ORDER BY vo.created_at DESC";
$stmt = $db->query($sql, $params);
$orders = $stmt->fetchAll();

// 设置响应头
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=orders_' . date('YmdHis') . '.csv');

// 创建输出流
$output = fopen('php://output', 'w');

// 写入UTF-8 BOM
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// 写入表头
fputcsv($output, [
    '订单号',
    '用户昵称',
    '金额',
    'VIP天数',
    '状态',
    '创建时间',
    '支付时间',
    '交易号'
]);

// 状态映射
$status_map = [
    'pending' => '待支付',
    'paid' => '已支付',
    'cancelled' => '已取消'
];

// 写入数据
foreach ($orders as $order) {
    fputcsv($output, [
        $order['order_no'],
        $order['nickname'],
        $order['amount'],
        $order['days'],
        $status_map[$order['status']] ?? $order['status'],
        $order['created_at'],
        $order['paid_at'] ?? '',
        $order['trade_no'] ?? ''
    ]);
}

// 关闭输出流
fclose($output); 