<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../../config/config.php';
require_once '../../includes/Database.php';
require_once '../../includes/Admin.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();

// 初始化数据库连接
$db = Database::getInstance();

// 检查请求方法
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    die(json_encode(['success' => false, 'message' => '无效的请求方法']));
}

// 获取订单ID
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$id) {
    die(json_encode(['success' => false, 'message' => '订单ID不能为空']));
}

// 获取订单详情
$sql = "SELECT vo.*, u.nickname, u.avatar 
        FROM vip_orders vo 
        LEFT JOIN users u ON vo.user_id = u.id 
        WHERE vo.id = ?";
$stmt = $db->query($sql, [$id]);
$order = $stmt->fetch();

if (!$order) {
    die(json_encode(['success' => false, 'message' => '订单不存在']));
}

// 格式化时间
$order['created_at'] = date('Y-m-d H:i:s', strtotime($order['created_at']));
$order['paid_at'] = $order['paid_at'] ? date('Y-m-d H:i:s', strtotime($order['paid_at'])) : null;

// 返回订单详情
echo json_encode([
    'success' => true,
    'data' => $order
]); 