<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Admin.php';

$admin = new Admin();
$admin->checkAccess(); // 验证管理员权限

$error = '';
$success = '';

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currentPassword = $_POST['current_password'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    // 验证新密码
    if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
        $error = '所有字段都必须填写';
    } else if ($newPassword !== $confirmPassword) {
        $error = '新密码和确认密码不匹配';
    } else if (strlen($newPassword) < 8) {
        $error = '新密码长度必须至少为8个字符';
    } else {
        // 验证当前密码并更新
        if ($admin->changePassword($currentPassword, $newPassword)) {
            $success = '密码修改成功';
        } else {
            $error = '当前密码错误';
        }
    }
}

$pageTitle = '修改密码';
$pageIcon = 'fas fa-key';
require 'layout/header.php';
?>

<div class="card">
    <div class="card-body">
        <h5 class="card-title mb-4">
            <i class="fas fa-key me-2"></i>修改密码
        </h5>
        
        <?php if ($error): ?>
        <div class="alert alert-danger" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?php echo htmlspecialchars($error); ?>
        </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
        <div class="alert alert-success" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo htmlspecialchars($success); ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="" class="needs-validation" novalidate>
            <div class="mb-3">
                <label for="current_password" class="form-label">当前密码</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                </div>
            </div>
            
            <div class="mb-3">
                <label for="new_password" class="form-label">新密码</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-key"></i></span>
                    <input type="password" class="form-control" id="new_password" name="new_password" 
                           required minlength="8">
                    <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('new_password')">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
                <div class="form-text">密码必须至少包含8个字符</div>
            </div>
            
            <div class="mb-4">
                <label for="confirm_password" class="form-label">确认新密码</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-key"></i></span>
                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('confirm_password')">
                        <i class="fas fa-eye"></i>
                    </button>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>保存修改
                </button>
                <a href="/admin/index.php" class="btn btn-link">返回首页</a>
            </div>
        </form>
    </div>
</div>

<script>
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const type = field.type === 'password' ? 'text' : 'password';
    field.type = type;
    
    // 更新按钮图标
    const icon = event.currentTarget.querySelector('i');
    icon.className = type === 'password' ? 'fas fa-eye' : 'fas fa-eye-slash';
}

// 表单验证
(function () {
    'use strict'
    const forms = document.querySelectorAll('.needs-validation')
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    })
})()
</script>

<?php require 'layout/footer.php'; ?> 