<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Admin.php';
require_once '../includes/Config.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();

$config = Config::getInstance();

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $configs = $_POST['config'];
    if ($config->batchUpdate($configs)) {
        $success = '配置更新成功';
    } else {
        $error = '配置更新失败';
    }
}

// 获取所有配置
$configs = $config->getAll();

// 设置页面标题
$pageTitle = '系统配置';
$pageIcon = 'fas fa-cog';
require_once 'layout/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">系统配置</h5>
                </div>
                <div class="card-body">
                    <?php if (isset($success)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo $success; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>

                    <?php if (isset($error)): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo $error; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>

                    <form method="post" id="configForm">
                        <?php foreach ($configs as $item): ?>
                        <div class="mb-3">
                            <label class="form-label">
                                <?php echo htmlspecialchars($item['description']); ?>
                            </label>
                            <?php if ($item['type'] === 'textarea'): ?>
                            <textarea name="config[<?php echo $item['key']; ?>]" 
                                    class="form-control" 
                                    rows="3"><?php echo htmlspecialchars($item['value']); ?></textarea>
                            <?php elseif ($item['type'] === 'switch'): ?>
                            <div class="form-check form-switch">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       name="config[<?php echo $item['key']; ?>]" 
                                       value="1" 
                                       <?php echo $item['value'] ? 'checked' : ''; ?>>
                            </div>
                            <?php else: ?>
                            <input type="<?php echo $item['type']; ?>" 
                                   name="config[<?php echo $item['key']; ?>]" 
                                   class="form-control" 
                                   value="<?php echo htmlspecialchars($item['value']); ?>">
                            <?php endif; ?>
                            <div class="form-text text-muted">
                                配置键名: <?php echo $item['key']; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary">
                                保存配置
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // 隐藏初始加载动画
    Loading.hide();

    // 配置表单提交
    document.getElementById('configForm').addEventListener('submit', function() {
        Loading.show();
    });
});
</script>

<?php require_once 'layout/footer.php'; ?> 