<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/Admin.php';

// 验证管理员权限
$admin = new Admin();
$admin->checkAccess();

// 检查是否有卡密可导出
if (empty($_SESSION['generated_cards'])) {
    header('Location: vip_cards.php');
    exit;
}

// 设置响应头
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="cards_' . date('YmdHis') . '.csv"');

// 创建输出流
$output = fopen('php://output', 'w');

// 写入BOM，解决Excel打开中文乱码
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// 写入表头
fputcsv($output, ['卡密号码']);

// 写入数据
foreach ($_SESSION['generated_cards'] as $card) {
    fputcsv($output, [$card]);
}

// 清除session中的卡密数据
unset($_SESSION['generated_cards']);

// 关闭输出流
fclose($output); 