<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

$pageTitle = '常见问题管理';
$pageIcon = 'fas fa-question-circle';

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Admin.php';
require_once '../includes/FAQ.php';

// 检查管理员登录
if (!isset($_SESSION['admin'])) {
    header('Location: /admin/login.php');
    exit;
}

$faq = new FAQ();
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$faqs = $faq->getAll($page);
$total = $faq->getTotal();

// 处理添加/编辑/删除操作
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create':
                // 处理图片上传
                $images = [];
                if (isset($_FILES['images'])) {
                    foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
                        if ($_FILES['images']['error'][$key] === UPLOAD_ERR_OK) {
                            $ext = pathinfo($_FILES['images']['name'][$key], PATHINFO_EXTENSION);
                            $filename = uniqid() . '.' . $ext;
                            $uploadPath = UPLOAD_PATH . $filename;
                            
                            if (move_uploaded_file($tmp_name, $uploadPath)) {
                                $images[] = '/uploads/' . $filename;
                            }
                        }
                    }
                }
                $_POST['images'] = !empty($images) ? implode('|', $images) : null;
                
                if ($faq->create($_POST)) {
                    header('Location: /admin/faq.php?success=created');
                    exit;
                }
                break;
            case 'update':
                // 处理图片上传
                $currentFaq = $faq->get($_POST['id']);
                $images = $currentFaq['images'] ? explode('|', $currentFaq['images']) : [];
                
                // 处理要删除的图片
                if (isset($_POST['delete_images']) && is_array($_POST['delete_images'])) {
                    foreach ($_POST['delete_images'] as $index) {
                        if (isset($images[$index])) {
                            $imagePath = UPLOAD_PATH . basename($images[$index]);
                            if (file_exists($imagePath)) {
                                unlink($imagePath);
                            }
                            unset($images[$index]);
                        }
                    }
                    $images = array_values($images); // 重新索引数组
                }
                
                // 处理新上传的图片
                if (isset($_FILES['images'])) {
                    foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
                        if ($_FILES['images']['error'][$key] === UPLOAD_ERR_OK) {
                            $ext = pathinfo($_FILES['images']['name'][$key], PATHINFO_EXTENSION);
                            $filename = uniqid() . '.' . $ext;
                            $uploadPath = UPLOAD_PATH . $filename;
                            
                            if (move_uploaded_file($tmp_name, $uploadPath)) {
                                $images[] = '/uploads/' . $filename;
                            }
                        }
                    }
                }
                
                $_POST['images'] = !empty($images) ? implode('|', $images) : null;
                
                if ($faq->update($_POST['id'], $_POST)) {
                    header('Location: /admin/faq.php?success=updated');
                    exit;
                }
                break;
            case 'delete':
                if ($faq->delete($_POST['id'])) {
                    header('Location: /admin/faq.php?success=deleted');
                    exit;
                }
                break;
        }
    }
}

require_once 'layout/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/layout/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?php
                switch ($_GET['success']) {
                    case 'created':
                        echo '常见问题添加成功！';
                        break;
                    case 'updated':
                        echo '常见问题更新成功！';
                        break;
                    case 'deleted':
                        echo '常见问题删除成功！';
                        break;
                }
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                <h1 class="h2">常见问题管理</h1>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createModal">
                    <i class="fas fa-plus me-1"></i>添加问题
                </button>
            </div>
            
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>问题</th>
                                    <th>分类</th>
                                    <th>排序</th>
                                    <th>状态</th>
                                    <th>更新时间</th>
                                    <th>操作</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($faqs as $item): ?>
                                <tr>
                                    <td><?php echo $item['id']; ?></td>
                                    <td><?php echo htmlspecialchars($item['question']); ?></td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo htmlspecialchars($item['category']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo $item['sort_order']; ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $item['status'] ? 'success' : 'secondary'; ?>">
                                            <?php echo $item['status'] ? '显示' : '隐藏'; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('Y-m-d H:i', strtotime($item['updated_at'])); ?></td>
                                    <td>
                                        <button type="button" 
                                                class="btn btn-sm btn-primary" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#editModal<?php echo $item['id']; ?>">
                                            编辑
                                        </button>
                                        <button type="button" 
                                                class="btn btn-sm btn-danger" 
                                                onclick="if(confirm('确定要删除这个问题吗？')) { document.getElementById('deleteForm<?php echo $item['id']; ?>').submit(); }">
                                            删除
                                        </button>
                                        <form id="deleteForm<?php echo $item['id']; ?>" 
                                              method="POST" 
                                              style="display: none;">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- 创建模态框 -->
<div class="modal fade" id="createModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data" class="faq-form">
                <input type="hidden" name="action" value="create">
                
                <div class="modal-header">
                    <h5 class="modal-title">添加常见问题</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">问题</label>
                        <input type="text" name="question" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">答案</label>
                        <textarea name="answer" class="form-control" rows="5" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">分类</label>
                        <input type="text" name="category" class="form-control" value="general" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">
                            上传图片
                            <small class="text-muted">（可选，最多3张）</small>
                        </label>
                        <input type="file" 
                               name="images[]" 
                               class="form-control" 
                               accept="image/*" 
                               multiple 
                               onchange="validateImages(this, 3)">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">排序</label>
                                <input type="number" name="sort_order" class="form-control" value="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">状态</label>
                                <select name="status" class="form-select">
                                    <option value="1">显示</option>
                                    <option value="0">隐藏</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">保存</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- 编辑模态框 -->
<?php foreach ($faqs as $item): ?>
<div class="modal fade" id="editModal<?php echo $item['id']; ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST" enctype="multipart/form-data" class="faq-form">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                
                <div class="modal-header">
                    <h5 class="modal-title">编辑常见问题</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">问题</label>
                        <input type="text" 
                               name="question" 
                               class="form-control" 
                               value="<?php echo htmlspecialchars($item['question']); ?>" 
                               required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">答案</label>
                        <textarea name="answer" 
                                  class="form-control" 
                                  rows="5" 
                                  required><?php echo htmlspecialchars($item['answer']); ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">分类</label>
                        <input type="text" 
                               name="category" 
                               class="form-control" 
                               value="<?php echo htmlspecialchars($item['category']); ?>" 
                               required>
                    </div>
                    
                    <?php if (!empty($item['images'])): ?>
                    <div class="mb-3">
                        <label class="form-label">当前图片</label>
                        <div class="row g-2">
                            <?php foreach (explode('|', $item['images']) as $index => $image): ?>
                            <div class="col-md-4">
                                <div class="position-relative">
                                    <img src="<?php echo htmlspecialchars($image); ?>" 
                                         class="img-thumbnail" 
                                         style="width: 100%; height: 150px; object-fit: cover;">
                                    <div class="form-check position-absolute top-0 end-0 m-2">
                                        <input type="checkbox" 
                                               name="delete_images[]" 
                                               value="<?php echo $index; ?>" 
                                               class="form-check-input bg-danger border-danger" 
                                               title="删除此图片">
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <small class="text-muted">选中图片前的复选框可删除对应图片</small>
                    </div>
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label class="form-label">
                            上传新图片
                            <small class="text-muted">（可选，最多3张）</small>
                        </label>
                        <input type="file" 
                               name="images[]" 
                               class="form-control" 
                               accept="image/*" 
                               multiple 
                               onchange="validateImages(this, 3)">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">排序</label>
                                <input type="number" 
                                       name="sort_order" 
                                       class="form-control" 
                                       value="<?php echo $item['sort_order']; ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">状态</label>
                                <select name="status" class="form-select">
                                    <option value="1" <?php echo $item['status'] ? 'selected' : ''; ?>>显示</option>
                                    <option value="0" <?php echo !$item['status'] ? 'selected' : ''; ?>>隐藏</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">保存</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; ?>

<script>
function validateImages(input, maxCount) {
    if (input.files.length > maxCount) {
        alert('最多只能上传' + maxCount + '张图片');
        input.value = '';
    }
}

// 表单提交处理
document.addEventListener('DOMContentLoaded', function() {
    // 隐藏初始加载动画
    Loading.hide();

    // FAQ表单提交
    document.querySelectorAll('.faq-form').forEach(form => {
        form.addEventListener('submit', function() {
            Loading.show();
        });
    });

    // 删除表单提交
    document.querySelectorAll('form[id^="deleteForm"]').forEach(form => {
        form.addEventListener('submit', function() {
            Loading.show();
        });
    });
});
</script>

<?php require_once 'layout/footer.php'; ?> 