<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

$pageTitle = '反馈管理';
$pageIcon = 'fas fa-comments';

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Admin.php';
require_once '../includes/Feedback.php';

// 检查管理员登录
if (!isset($_SESSION['admin'])) {
    header('Location: /admin/login.php');
    exit;
}

$feedback = new Feedback();
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$status = isset($_GET['status']) ? $_GET['status'] : null;
$feedbacks = $feedback->getAllFeedbacks($status, $page);
$stats = $feedback->getStats();

// 处理状态更新
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_status') {
    $id = $_POST['id'];
    $newStatus = $_POST['status'];
    $reply = $_POST['reply'];
    
    if ($feedback->updateStatus($id, $newStatus, $reply)) {
        header('Location: /admin/feedback.php?success=1');
        exit;
    }
}

require_once 'layout/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php require_once __DIR__ . '/layout/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i>反馈处理成功！
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                <h1 class="h2">反馈管理</h1>
            </div>
            
            <!-- 统计卡片 -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card text-white bg-secondary">
                        <div class="card-body">
                            <h5 class="card-title">待处理</h5>
                            <p class="card-text h2"><?php echo $stats['pending']; ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-primary">
                        <div class="card-body">
                            <h5 class="card-title">处理中</h5>
                            <p class="card-text h2"><?php echo $stats['processing']; ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-success">
                        <div class="card-body">
                            <h5 class="card-title">已解决</h5>
                            <p class="card-text h2"><?php echo $stats['resolved']; ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-dark">
                        <div class="card-body">
                            <h5 class="card-title">已关闭</h5>
                            <p class="card-text h2"><?php echo $stats['closed']; ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- 筛选器 -->
            <div class="card mb-4">
                <div class="card-body">
                    <form class="row g-3" method="GET">
                        <div class="col-auto">
                            <select name="status" class="form-select" onchange="this.form.submit()">
                                <option value="">全部状态</option>
                                <option value="pending" <?php echo $status === 'pending' ? 'selected' : ''; ?>>待处理</option>
                                <option value="processing" <?php echo $status === 'processing' ? 'selected' : ''; ?>>处理中</option>
                                <option value="resolved" <?php echo $status === 'resolved' ? 'selected' : ''; ?>>已解决</option>
                                <option value="closed" <?php echo $status === 'closed' ? 'selected' : ''; ?>>已关闭</option>
                            </select>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- 反馈列表 -->
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>用户</th>
                                    <th>类型</th>
                                    <th>标题</th>
                                    <th>状态</th>
                                    <th>提交时间</th>
                                    <th>操作</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($feedbacks as $item): ?>
                                <tr>
                                    <td><?php echo $item['id']; ?></td>
                                    <td>
                                        <img src="<?php echo htmlspecialchars($item['avatar']); ?>" 
                                             class="rounded-circle me-2" 
                                             width="24" height="24" 
                                             alt="<?php echo htmlspecialchars($item['nickname']); ?>">
                                        <?php echo htmlspecialchars($item['nickname']); ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo getTypeColor($item['type']); ?>">
                                            <?php echo getTypeText($item['type']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($item['title']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo getStatusColor($item['status']); ?>">
                                            <?php echo getStatusText($item['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('Y-m-d H:i', strtotime($item['created_at'])); ?></td>
                                    <td>
                                        <button type="button" 
                                                class="btn btn-sm btn-primary" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#replyModal<?php echo $item['id']; ?>">
                                            处理
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- 回复模态框 -->
<?php foreach ($feedbacks as $item): ?>
<div class="modal fade" id="replyModal<?php echo $item['id']; ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="POST" class="feedback-form">
                <input type="hidden" name="action" value="update_status">
                <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                
                <div class="modal-header">
                    <h5 class="modal-title">处理反馈</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">反馈内容</label>
                        <div class="border rounded p-3 bg-light">
                            <?php echo nl2br(htmlspecialchars($item['content'])); ?>
                        </div>
                    </div>
                    
                    <?php if ($item['images']): ?>
                    <div class="mb-3">
                        <label class="form-label">附带图片</label>
                        <div class="row g-2">
                            <?php foreach (explode('|', $item['images']) as $image): ?>
                            <div class="col-auto">
                                <a href="<?php echo $image; ?>" target="_blank">
                                    <img src="<?php echo $image; ?>" 
                                         class="img-thumbnail" 
                                         style="max-width: 100px;">
                                </a>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label class="form-label">更新状态</label>
                        <select name="status" class="form-select" required>
                            <option value="pending" <?php echo $item['status'] === 'pending' ? 'selected' : ''; ?>>待处理</option>
                            <option value="processing" <?php echo $item['status'] === 'processing' ? 'selected' : ''; ?>>处理中</option>
                            <option value="resolved" <?php echo $item['status'] === 'resolved' ? 'selected' : ''; ?>>已解决</option>
                            <option value="closed" <?php echo $item['status'] === 'closed' ? 'selected' : ''; ?>>已关闭</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">回复内容</label>
                        <textarea name="reply" 
                                  class="form-control" 
                                  rows="3" 
                                  required><?php echo htmlspecialchars($item['admin_reply'] ?? ''); ?></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">保存</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // 隐藏初始加载动画
    Loading.hide();

    // 反馈表单提交
    document.querySelectorAll('.feedback-form').forEach(form => {
        form.addEventListener('submit', function() {
            Loading.show();
        });
    });
});
</script>

<?php require_once 'layout/footer.php'; ?>

<?php
function getTypeColor($type) {
    switch ($type) {
        case 'bug':
            return 'danger';
        case 'suggestion':
            return 'info';
        default:
            return 'secondary';
    }
}

function getTypeText($type) {
    switch ($type) {
        case 'bug':
            return '问题反馈';
        case 'suggestion':
            return '功能建议';
        default:
            return '其他';
    }
}

function getStatusColor($status) {
    switch ($status) {
        case 'pending':
            return 'secondary';
        case 'processing':
            return 'primary';
        case 'resolved':
            return 'success';
        case 'closed':
            return 'dark';
        default:
            return 'secondary';
    }
}

function getStatusText($status) {
    switch ($status) {
        case 'pending':
            return '待处理';
        case 'processing':
            return '处理中';
        case 'resolved':
            return '已解决';
        case 'closed':
            return '已关闭';
        default:
            return '未知状态';
    }
} 