<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

$pageTitle = '控制面板';
$pageIcon = 'fas fa-tachometer-alt';

require_once '../includes/Admin.php';
$admin = new Admin();

// 获取统计数据
$stats = $admin->getOverallStats();
$dailyStats = $admin->getDailyStats(30);
$hourlyStats = $admin->getHourlyStats();
$hotPosts = $admin->getHotPosts(5);
$activeUsers = $admin->getActiveUsers(5);

require_once 'layout/header.php';
?>

<!-- 总体统计 -->
<div class="row">
    <div class="col-xl-3 col-md-6">
        <div class="stat-card">
            <div class="icon text-primary">
                <i class="fas fa-users"></i>
            </div>
            <div class="number"><?php echo number_format($stats['total_users']); ?></div>
            <div class="label">总用户数</div>
            <div class="text-muted small">
                今日新增访客：<?php echo number_format($stats['today_visitors']); ?>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="stat-card">
            <div class="icon text-success">
                <i class="fas fa-file-alt"></i>
            </div>
            <div class="number"><?php echo number_format($stats['total_posts']); ?></div>
            <div class="label">总动态数</div>
            <div class="text-muted small">
                今日被访问：<?php echo number_format($stats['today_posts']); ?> 条
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="stat-card">
            <div class="icon text-info">
                <i class="fas fa-eye"></i>
            </div>
            <div class="number"><?php echo number_format($stats['total_views']); ?></div>
            <div class="label">总浏览量</div>
            <div class="text-muted small">
                今日浏览：<?php echo number_format($stats['today_visits']); ?> 次
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="stat-card">
            <div class="icon text-warning">
                <i class="fas fa-user-friends"></i>
            </div>
            <div class="number"><?php echo number_format($stats['total_visitors']); ?></div>
            <div class="label">总访客数</div>
            <div class="text-muted small">
                今日访客：<?php echo number_format($stats['today_visitors']); ?> 人
            </div>
        </div>
    </div>
</div>

<!-- 图表 -->
<div class="row mt-4">
    <!-- 访问趋势 -->
    <div class="col-xl-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">访问趋势</h5>
            </div>
            <div class="card-body">
                <canvas id="visitChart" height="300"></canvas>
            </div>
        </div>
    </div>
    <!-- 时段分布 -->
    <div class="col-xl-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">访问时段分布</h5>
            </div>
            <div class="card-body">
                <canvas id="hourlyChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- 排行榜 -->
<div class="row mt-4">
    <!-- 热门动态 -->
    <div class="col-xl-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="card-title">热门动态排行</h5>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>排名</th>
                            <th>用户</th>
                            <th>内容</th>
                            <th>浏览量</th>
                            <th>访客数</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($hotPosts as $index => $post): ?>
                        <tr>
                            <td>
                                <?php if ($index < 3): ?>
                                <span class="badge bg-<?php echo ['warning', 'secondary', 'info'][$index]; ?>">
                                    <?php echo $index + 1; ?>
                                </span>
                                <?php else: ?>
                                <?php echo $index + 1; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="<?php echo htmlspecialchars($post['avatar']); ?>" 
                                         class="rounded-circle me-2" 
                                         width="32" height="32" 
                                         alt="<?php echo htmlspecialchars($post['nickname']); ?>">
                                    <?php echo htmlspecialchars($post['nickname']); ?>
                                </div>
                            </td>
                            <td>
                                <?php
                                $content = $post['content'];
                                if (mb_strlen($content) > 30) {
                                    $content = mb_substr($content, 0, 30) . '...';
                                }
                                echo htmlspecialchars($content);
                                ?>
                            </td>
                            <td><?php echo number_format($post['view_count']); ?></td>
                            <td><?php echo number_format($post['visitor_count']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- 活跃用户 -->
    <div class="col-xl-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="card-title">活跃用户排行</h5>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>排名</th>
                            <th>用户</th>
                            <th>动态数</th>
                            <th>总浏览</th>
                            <th>总访客</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($activeUsers as $index => $user): ?>
                        <tr>
                            <td>
                                <?php if ($index < 3): ?>
                                <span class="badge bg-<?php echo ['warning', 'secondary', 'info'][$index]; ?>">
                                    <?php echo $index + 1; ?>
                                </span>
                                <?php else: ?>
                                <?php echo $index + 1; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="<?php echo htmlspecialchars($user['avatar']); ?>" 
                                         class="rounded-circle me-2" 
                                         width="32" height="32" 
                                         alt="<?php echo htmlspecialchars($user['nickname']); ?>">
                                    <?php echo htmlspecialchars($user['nickname']); ?>
                                </div>
                            </td>
                            <td><?php echo number_format($user['post_count']); ?></td>
                            <td><?php echo number_format($user['total_views']); ?></td>
                            <td><?php echo number_format($user['total_visitors']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // 访问趋势图
    const dailyStats = <?php echo json_encode(array_reverse($dailyStats)); ?>;
    const visitChart = new Chart(document.getElementById('visitChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: dailyStats.map(item => item.date),
            datasets: [
                {
                    label: '访问量',
                    data: dailyStats.map(item => item.visit_count),
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4
                },
                {
                    label: '访客数',
                    data: dailyStats.map(item => item.visitor_count),
                    borderColor: '#1cc88a',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.4
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        borderDash: [2, 4]
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // 时段分布图
    const hourlyStats = <?php echo json_encode($hourlyStats); ?>;
    const hourlyChart = new Chart(document.getElementById('hourlyChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: hourlyStats.map(item => item.hour + '时'),
            datasets: [{
                label: '访问量',
                data: hourlyStats.map(item => item.visit_count),
                backgroundColor: '#36b9cc',
                borderRadius: 4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        borderDash: [2, 4]
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
});
</script>

<?php require_once 'layout/footer.php'; ?> 