<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

$pageTitle = '动态管理';
$pageIcon = 'fas fa-file-alt';

require_once '../includes/Admin.php';
$admin = new Admin();

// 获取当前页码
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page);
$limit = 10;

// 获取动态列表和总数
$posts = $admin->getAllPosts($page, $limit);
$totalPosts = $admin->getPostCount();
$totalPages = ceil($totalPosts / $limit);

require_once 'layout/header.php';
?>

<!-- 动态列表 -->
<div class="table-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title">动态列表</h5>
        <div class="d-flex align-items-center">
            <span class="text-muted me-3">
                共 <?php echo number_format($totalPosts); ?> 条动态
            </span>
            <div class="input-group" style="width: 300px;">
                <input type="text" class="form-control" id="searchInput" placeholder="搜索动态内容...">
                <button class="btn btn-outline-secondary" type="button" id="searchBtn">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>用户</th>
                    <th>内容</th>
                    <th>图片</th>
                    <th>浏览量</th>
                    <th>访客数</th>
                    <th>发布时间</th>
                    <th>操作</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($posts as $post): ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            <img src="<?php echo htmlspecialchars($post['avatar']); ?>" 
                                 class="rounded-circle me-2" 
                                 width="32" height="32" 
                                 alt="<?php echo htmlspecialchars($post['nickname']); ?>">
                            <?php echo htmlspecialchars($post['nickname']); ?>
                        </div>
                    </td>
                    <td>
                        <?php
                        $content = $post['content'];
                        if (mb_strlen($content) > 50) {
                            $content = mb_substr($content, 0, 50) . '...';
                        }
                        echo htmlspecialchars($content);
                        ?>
                    </td>
                    <td>
                        <?php if ($post['image']): ?>
                        <a href="<?php echo htmlspecialchars($post['image']); ?>" 
                           target="_blank" 
                           class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-image"></i>
                        </a>
                        <?php else: ?>
                        <span class="text-muted">无图片</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo number_format($post['view_count']); ?></td>
                    <td><?php echo number_format($post['visitor_count']); ?></td>
                    <td><?php echo date('Y-m-d H:i', strtotime($post['created_at'])); ?></td>
                    <td>
                        <div class="btn-group">
                            <a href="/posts/share.php?code=<?php echo $post['share_code']; ?>" 
                               target="_blank"
                               class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                            <button type="button" 
                                    class="btn btn-sm btn-outline-danger delete-post" 
                                    data-id="<?php echo $post['id']; ?>"
                                    data-user="<?php echo htmlspecialchars($post['nickname']); ?>">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- 分页 -->
    <?php if ($totalPages > 1): ?>
    <div class="card-footer">
        <nav>
            <ul class="pagination justify-content-center mb-0">
                <?php if ($page > 1): ?>
                <li class="page-item">
                    <a class="page-link" href="?page=<?php echo $page - 1; ?>">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                </li>
                <?php endif; ?>

                <?php
                $startPage = max(1, $page - 2);
                $endPage = min($totalPages, $page + 2);
                
                if ($startPage > 1) {
                    echo '<li class="page-item"><a class="page-link" href="?page=1">1</a></li>';
                    if ($startPage > 2) {
                        echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                    }
                }

                for ($i = $startPage; $i <= $endPage; $i++) {
                    echo '<li class="page-item' . ($i === $page ? ' active' : '') . '">';
                    echo '<a class="page-link" href="?page=' . $i . '">' . $i . '</a>';
                    echo '</li>';
                }

                if ($endPage < $totalPages) {
                    if ($endPage < $totalPages - 1) {
                        echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                    }
                    echo '<li class="page-item"><a class="page-link" href="?page=' . $totalPages . '">' . $totalPages . '</a></li>';
                }
                ?>

                <?php if ($page < $totalPages): ?>
                <li class="page-item">
                    <a class="page-link" href="?page=<?php echo $page + 1; ?>">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
    <?php endif; ?>
</div>

<!-- 删除确认模态框 -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">确认删除</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>确定要删除 <span id="deletePostUser"></span> 的这条动态吗？</p>
                <p class="text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    此操作将同时删除该动态的所有访问记录！
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">
                    <i class="fas fa-trash-alt me-2"></i>确定删除
                </button>
            </div>
        </div>
    </div>
</div>

<!-- 动态管理脚本 -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // 删除动态
    let postIdToDelete = null;
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));

    document.querySelectorAll('.delete-post').forEach(button => {
        button.addEventListener('click', function() {
            postIdToDelete = this.dataset.id;
            document.getElementById('deletePostUser').textContent = this.dataset.user;
            deleteModal.show();
        });
    });

    document.getElementById('confirmDelete').addEventListener('click', function() {
        if (postIdToDelete) {
            fetch(`/admin/api/delete_post.php?id=${postIdToDelete}`, {
                method: 'POST'
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert(data.message || '删除失败');
                }
            })
            .catch(error => {
                alert('删除失败');
            });
        }
    });

    // 搜索功能
    const searchInput = document.getElementById('searchInput');
    const searchBtn = document.getElementById('searchBtn');
    const tbody = document.querySelector('tbody');

    function searchPosts() {
        const keyword = searchInput.value.toLowerCase();
        const rows = tbody.getElementsByTagName('tr');

        for (let row of rows) {
            const content = row.cells[1].textContent.toLowerCase();
            const user = row.cells[0].textContent.toLowerCase();
            row.style.display = content.includes(keyword) || user.includes(keyword) ? '' : 'none';
        }
    }

    searchBtn.addEventListener('click', searchPosts);
    searchInput.addEventListener('keyup', function(e) {
        if (e.key === 'Enter') {
            searchPosts();
        }
    });
});
</script>

<?php require_once 'layout/footer.php'; ?> 