/**
 * 朋友圈访客查询系统 - 后台管理脚本
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

// LiveData 已在 app.js 中定义，此处无需重复定义

// 页面加载完成后执行
document.addEventListener('DOMContentLoaded', function() {
    // 隐藏初始加载动画
    Loading.hide();

    // 侧边栏切换
    document.querySelector('.sidebar-toggle').addEventListener('click', function() {
        document.body.classList.toggle('sidebar-collapsed');
    });

    // 激活当前菜单
    const currentPath = window.location.pathname;
    document.querySelectorAll('.sidebar-menu .menu-link').forEach(link => {
        if (link.getAttribute('href') === currentPath) {
            link.parentElement.classList.add('active');
        }
    });

    // 初始化帮助提示
    const driver = new Driver({
        animate: true,
        opacity: 0.7,
        padding: 5,
        showButtons: ['next', 'previous', 'close'],
        showProgress: true,
        closeBtnText: '关闭',
        prevBtnText: '上一步',
        nextBtnText: '下一步',
        doneBtnText: '完成'
    });

    // 绑定帮助按钮
    const startTourBtn = document.getElementById('startTour');
    if (startTourBtn) {
        startTourBtn.addEventListener('click', function() {
            driver.defineSteps([
                {
                    element: '.menu-item[data-step="1"]',
                    popover: {
                        title: '控制面板',
                        description: '这里是系统的控制面板，展示整体数据概况',
                        position: 'right'
                    }
                },
                {
                    element: '.menu-item[data-step="2"]',
                    popover: {
                        title: '用户管理',
                        description: '在这里管理所有用户',
                        position: 'right'
                    }
                },
                {
                    element: '.menu-item[data-step="3"]',
                    popover: {
                        title: '动态管理',
                        description: '在这里管理所有动态内容',
                        position: 'right'
                    }
                },
                {
                    element: '.menu-item[data-step="4"]',
                    popover: {
                        title: '访问统计',
                        description: '查看详细的访问统计数据',
                        position: 'right'
                    }
                }
            ]);
            driver.start();
        });
    }

    // 自动刷新数据
    if (typeof refreshData === 'function') {
        LiveData.start('pageData', async () => {
            try {
                Loading.show();
                await refreshData();
            } finally {
                Loading.hide();
            }
        }, 30000); // 每30秒刷新一次
    }

    // 在页面离开时停止所有定时器
    window.addEventListener('beforeunload', function() {
        LiveData.stopAll();
    });

    // 删除确认
    const deleteModal = document.getElementById('deleteModal');
    if (deleteModal) {
        const modal = new bootstrap.Modal(deleteModal);
        let itemToDelete = null;

        // 删除用户
        document.querySelectorAll('.delete-user').forEach(button => {
            button.addEventListener('click', function() {
                itemToDelete = this.dataset.id;
                document.getElementById('deleteUserName').textContent = this.dataset.name;
                modal.show();
            });
        });

        // 删除动态
        document.querySelectorAll('.delete-post').forEach(button => {
            button.addEventListener('click', function() {
                itemToDelete = this.dataset.id;
                document.getElementById('deletePostUser').textContent = this.dataset.user;
                modal.show();
            });
        });

        // 确认删除
        document.getElementById('confirmDelete')?.addEventListener('click', async function() {
            if (!itemToDelete) return;

            const isUser = !!document.querySelector('.delete-user');
            const url = isUser ? '/admin/api/delete_user.php' : '/admin/api/delete_post.php';

            try {
                Loading.show();
                modal.hide();

                const response = await fetch(`${url}?id=${itemToDelete}`, {
                    method: 'POST'
                });
                const data = await response.json();

                if (data.success) {
                    location.reload();
                } else {
                    Toast.error(data.message || '删除失败');
                }
            } catch (error) {
                Toast.error('删除失败');
            } finally {
                Loading.hide();
            }
        });
    }

    // 搜索功能
    const searchInput = document.getElementById('searchInput');
    const searchBtn = document.getElementById('searchBtn');
    if (searchInput && searchBtn) {
        const tbody = document.querySelector('tbody');
        
        function searchItems() {
            const keyword = searchInput.value.toLowerCase();
            const rows = tbody.getElementsByTagName('tr');
            const searchColumn = document.querySelector('.delete-user') ? 1 : 1; // 用户搜索昵称，动态搜索内容

            for (let row of rows) {
                const text = row.cells[searchColumn].textContent.toLowerCase();
                row.style.display = text.includes(keyword) ? '' : 'none';
            }
        }

        searchBtn.addEventListener('click', searchItems);
        searchInput.addEventListener('keyup', function(e) {
            if (e.key === 'Enter') {
                searchItems();
            }
        });
    }
}); 