<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

$pageTitle = '常见问题';
require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/FAQ.php';

$faq = new FAQ();
$categories = $faq->getCategories();
$currentCategory = isset($_GET['category']) ? $_GET['category'] : null;
$faqs = $currentCategory ? $faq->getFAQsByCategory($currentCategory) : $faq->getPublicFAQs();

require_once '../includes/header.php';
?>

<div class="faq-page">
    <div class="container">
        <div class="faq-header">
            <h1>常见问题</h1>
            <p>您可以在这里找到关于系统使用的常见问题解答</p>
        </div>

        <div class="row">
            <!-- 左侧分类列表 -->
            <div class="col-md-3">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-list me-2"></i>问题分类
                        </h5>
                    </div>
                    <div class="list-group list-group-flush">
                        <a href="/faq" 
                           class="list-group-item list-group-item-action d-flex justify-content-between align-items-center <?php echo !$currentCategory ? 'active' : ''; ?>">
                            <span><i class="fas fa-folder me-2"></i>全部问题</span>
                            <span class="badge bg-primary rounded-pill">
                                <?php echo count($faqs); ?>
                            </span>
                        </a>
                        <?php foreach ($categories as $category): ?>
                        <a href="/faq?category=<?php echo urlencode($category); ?>" 
                           class="list-group-item list-group-item-action d-flex justify-content-between align-items-center <?php echo $currentCategory === $category ? 'active' : ''; ?>">
                            <span><i class="fas fa-folder me-2"></i><?php echo htmlspecialchars($category); ?></span>
                            <span class="badge bg-primary rounded-pill">
                                <?php 
                                $categoryFaqs = $faq->getFAQsByCategory($category);
                                echo count($categoryFaqs);
                                ?>
                            </span>
                        </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <!-- 右侧问题列表 -->
            <div class="col-md-9">
                <div class="faq-categories">
                    <button class="category-btn <?php echo !$currentCategory ? 'active' : ''; ?>" 
                            onclick="window.location.href='/faq'">
                        <i class="fas fa-list-ul me-2"></i>全部
                    </button>
                    <?php foreach ($categories as $category): ?>
                    <button class="category-btn <?php echo $currentCategory === $category ? 'active' : ''; ?>"
                            onclick="window.location.href='/faq?category=<?php echo urlencode($category); ?>'">
                        <?php echo htmlspecialchars($category); ?>
                    </button>
                    <?php endforeach; ?>
                </div>

                <?php if (!empty($faqs)): ?>
                    <div class="accordion" id="faqAccordion">
                        <?php foreach ($faqs as $index => $item): ?>
                        <div class="faq-item">
                            <div class="faq-question collapsed" 
                                 data-bs-toggle="collapse" 
                                 data-bs-target="#faq<?php echo $index; ?>">
                                <?php echo htmlspecialchars($item['question']); ?>
                                <i class="fas fa-chevron-down"></i>
                            </div>
                            <div id="faq<?php echo $index; ?>" 
                                 class="collapse" 
                                 data-bs-parent="#faqAccordion">
                                <div class="faq-answer">
                                    <?php echo nl2br(htmlspecialchars($item['answer'])); ?>
                                    
                                    <?php if (!empty($item['images'])): ?>
                                    <div class="faq-images mt-3">
                                        <div class="row g-2">
                                            <?php foreach (explode('|', $item['images']) as $image): ?>
                                            <div class="col-md-4">
                                                <a href="<?php echo htmlspecialchars($image); ?>" 
                                                   target="_blank" 
                                                   class="d-block">
                                                    <img src="<?php echo htmlspecialchars($image); ?>" 
                                                         class="img-fluid rounded" 
                                                         alt="FAQ图片">
                                                </a>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-info-circle fa-3x text-muted mb-3"></i>
                    <p class="text-muted">暂无常见问题</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // 隐藏初始加载动画
    Loading.hide();
});
</script>

<?php require_once '../includes/footer.php'; ?> 