<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Feedback.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

// 获取反馈ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) {
    header('Location: /feedback/list.php');
    exit;
}

// 获取反馈详情
$feedback = new Feedback();
$item = $feedback->getFeedback($id);

// 检查是否是当前用户的反馈
if (!$item || $item['user_id'] != $_SESSION['user']['id']) {
    header('Location: /feedback/list.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>反馈详情 - 朋友圈访客查询系统</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <!-- 加载动画 -->
    <div class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">加载中...</div>
    </div>

    <div class="feedback-page">
        <div class="container">
            <div class="feedback-header">
                <h1>反馈详情</h1>
                <p>查看反馈的详细信息和处理进度</p>
            </div>

            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="feedback-detail">
                        <div class="detail-header">
                            <a href="/feedback/list.php" class="btn-back">
                                <i class="fas fa-arrow-left"></i>
                                返回列表
                            </a>
                        </div>

                        <div class="detail-content">
                            <div class="detail-title">
                                <h2><?php echo htmlspecialchars($item['title']); ?></h2>
                                <div class="detail-meta">
                                    <span class="meta-item">
                                        <i class="fas fa-calendar"></i>
                                        <?php echo date('Y-m-d H:i', strtotime($item['created_at'])); ?>
                                    </span>
                                    <span class="meta-item">
                                        <i class="fas fa-tag"></i>
                                        <?php
                                        $typeTexts = [
                                            'bug' => '问题反馈',
                                            'suggestion' => '功能建议',
                                            'other' => '其他'
                                        ];
                                        echo $typeTexts[$item['type']] ?? '未知类型';
                                        ?>
                                    </span>
                                    <span class="feedback-status <?php echo $item['status']; ?>">
                                        <?php
                                        $statusTexts = [
                                            'pending' => '待处理',
                                            'processing' => '处理中',
                                            'resolved' => '已解决',
                                            'closed' => '已关闭'
                                        ];
                                        echo $statusTexts[$item['status']] ?? '未知状态';
                                        ?>
                                    </span>
                                </div>
                            </div>

                            <div class="detail-description">
                                <?php echo nl2br(htmlspecialchars($item['content'])); ?>
                            </div>

                            <?php if ($item['images']): ?>
                            <div class="detail-images">
                                <h3>附带图片</h3>
                                <div class="image-grid">
                                    <?php foreach (explode('|', $item['images']) as $image): ?>
                                    <a href="<?php echo htmlspecialchars($image); ?>" 
                                       target="_blank" 
                                       class="image-item">
                                        <img src="<?php echo htmlspecialchars($image); ?>" 
                                             alt="反馈图片">
                                    </a>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if ($item['admin_reply']): ?>
                            <div class="detail-reply">
                                <h3>管理员回复</h3>
                                <div class="reply-content">
                                    <?php echo nl2br(htmlspecialchars($item['admin_reply'])); ?>
                                </div>
                                <div class="reply-time">
                                    <i class="fas fa-clock"></i>
                                    回复时间：<?php echo date('Y-m-d H:i', strtotime($item['updated_at'])); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // 隐藏初始加载动画
        Loading.hide();
    });
    </script>

    <?php include '../includes/footer.php'; ?>
</body>
</html> 