<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

class Feedback {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    // 创建新反馈
    public function create($userId, $type, $title, $content, $images = null) {
        $sql = "INSERT INTO feedback (user_id, type, title, content, images) VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->db->query($sql, [$userId, $type, $title, $content, $images]);
        return $this->db->getConnection()->lastInsertId();
    }
    
    // 获取用户的反馈列表
    public function getUserFeedbacks($userId, $page = 1, $limit = 10) {
        $offset = ($page - 1) * $limit;
        $sql = "SELECT * FROM feedback WHERE user_id = ? ORDER BY created_at DESC LIMIT ? OFFSET ?";
        return $this->db->query($sql, [$userId, $limit, $offset])->fetchAll();
    }
    
    // 获取反馈详情
    public function getFeedback($id) {
        $sql = "SELECT f.*, u.nickname, u.avatar 
                FROM feedback f 
                LEFT JOIN users u ON f.user_id = u.id 
                WHERE f.id = ?";
        return $this->db->query($sql, [$id])->fetch();
    }
    
    // 更新反馈状态（管理员使用）
    public function updateStatus($id, $status, $adminReply = null) {
        $sql = "UPDATE feedback SET status = ?, admin_reply = ? WHERE id = ?";
        return $this->db->query($sql, [$status, $adminReply, $id])->rowCount() > 0;
    }
    
    // 获取所有反馈（管理员使用）
    public function getAllFeedbacks($status = null, $page = 1, $limit = 10) {
        $offset = ($page - 1) * $limit;
        $params = [];
        $sql = "SELECT f.*, u.nickname, u.avatar 
                FROM feedback f 
                LEFT JOIN users u ON f.user_id = u.id";
        
        if ($status) {
            $sql .= " WHERE f.status = ?";
            $params[] = $status;
        }
        
        $sql .= " ORDER BY f.created_at DESC LIMIT ? OFFSET ?";
        $params[] = $limit;
        $params[] = $offset;
        
        return $this->db->query($sql, $params)->fetchAll();
    }
    
    // 获取反馈统计
    public function getStats() {
        $sql = "SELECT 
                COUNT(*) as total,
                SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
                SUM(CASE WHEN status = 'processing' THEN 1 ELSE 0 END) as processing,
                SUM(CASE WHEN status = 'resolved' THEN 1 ELSE 0 END) as resolved,
                SUM(CASE WHEN status = 'closed' THEN 1 ELSE 0 END) as closed
                FROM feedback";
        return $this->db->query($sql)->fetch();
    }
} 