<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once __DIR__ . '/Config.php';

class WechatAuth {
    private $appId;
    private $appSecret;
    private $db;
    private $config;

    public function __construct() {
        $this->config = Config::getInstance();
        $this->appId = $this->config->get('wechat_appid');
        $this->appSecret = $this->config->get('wechat_secret');
        $this->db = Database::getInstance();
    }

    // 获取微信登录URL
    public function getLoginUrl() {
        $redirectUri = urlencode($this->config->get('site_url') . '/auth/wechat_callback.php');
        $state = $this->generateState();
        $_SESSION['wechat_state'] = $state;
        
        return sprintf(
            "https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_login&state=%s#wechat_redirect",
            $this->appId,
            $redirectUri,
            $state
        );
    }

    // 处理回调
    public function handleCallback($code, $state) {
        if (!isset($_SESSION['wechat_state']) || $_SESSION['wechat_state'] !== $state) {
            throw new Exception('非法的state参数');
        }

        // 获取访问令牌
        $tokenUrl = sprintf(
            "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code",
            $this->appId,
            $this->appSecret,
            $code
        );

        $response = $this->httpGet($tokenUrl);
        $token = json_decode($response, true);

        if (isset($token['errcode'])) {
            throw new Exception('获取访问令牌失败：' . $token['errmsg']);
        }

        // 获取用户信息
        $userInfoUrl = sprintf(
            "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s",
            $token['access_token'],
            $token['openid']
        );

        $response = $this->httpGet($userInfoUrl);
        $userInfo = json_decode($response, true);

        if (isset($userInfo['errcode'])) {
            throw new Exception('获取用户信息失败：' . $userInfo['errmsg']);
        }

        // 保存或更新用户信息
        return $this->saveUser($userInfo);
    }

    // 保存用户信息到数据库
    private function saveUser($userInfo) {
        $sql = "SELECT * FROM users WHERE openid = ?";
        $result = $this->db->query($sql, [$userInfo['openid']])->fetch();

        if ($result) {
            // 更新用户信息
            $sql = "UPDATE users SET nickname = ?, avatar = ?, last_login = NOW() WHERE openid = ?";
            $this->db->query($sql, [
                $userInfo['nickname'],
                $userInfo['headimgurl'],
                $userInfo['openid']
            ]);
            return $result;
        } else {
            // 创建新用户
            $sql = "INSERT INTO users (openid, nickname, avatar) VALUES (?, ?, ?)";
            $this->db->query($sql, [
                $userInfo['openid'],
                $userInfo['nickname'],
                $userInfo['headimgurl']
            ]);
            return $this->db->query("SELECT * FROM users WHERE openid = ?", [$userInfo['openid']])->fetch();
        }
    }

    // 生成随机state参数
    private function generateState() {
        return bin2hex(random_bytes(16));
    }

    // HTTP GET请求
    private function httpGet($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
} 