<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Post.php';
require_once '../includes/User.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /');
    exit;
}

// 检查用户是否是VIP
$user = new User();
if (!$user->isVip()) {
    header('Location: /vip/index.php');
    exit;
}

// 获取用户的动态列表
$post = new Post();
$posts = $post->getUserPosts($_SESSION['user']['id']);

// 获取用户的统计数据
$stats = $post->getUserStats($_SESSION['user']['id']);

// 加载页头
require_once '../includes/header.php';
?>

<style>
.image-grid {
    display: grid;
    gap: 6px;
    margin-bottom: 16px;
}

.image-grid.grid-1 {
    grid-template-columns: 1fr;
}

.image-grid.grid-2,
.image-grid.grid-3,
.image-grid.grid-4 {
    grid-template-columns: repeat(2, 1fr);
}

.image-grid.grid-5,
.image-grid.grid-6,
.image-grid.grid-7,
.image-grid.grid-8,
.image-grid.grid-9 {
    grid-template-columns: repeat(3, 1fr);
}

.image-item {
    position: relative;
    padding-bottom: 100%;
    background: #f5f5f5;
    border-radius: 8px;
    overflow: hidden;
}

.image-item img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.image-grid.grid-1 .image-item {
    padding-bottom: 56.25%; /* 16:9 比例 */
}

.stats-card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    transition: transform 0.2s;
}

.stats-card:hover {
    transform: translateY(-2px);
}

.stats-icon {
    width: 48px;
    height: 48px;
    background: rgba(var(--bs-primary-rgb), 0.1);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--bs-primary);
    font-size: 24px;
}

.post-card {
    cursor: pointer;
    transition: transform 0.2s, box-shadow 0.2s;
}

.post-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.post-card .btn-group {
    z-index: 2;
}

.post-card .card-body {
    position: relative;
}

.post-card .card-link {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    z-index: 1;
}
</style>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="h4 mb-0">我的动态</h2>
                <a href="/posts/create.php" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>发布新动态
                </a>
            </div>

            <!-- 数据统计面板 -->
            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <div class="stats-card p-3">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon me-3">
                                <i class="fas fa-eye"></i>
                            </div>
                            <div>
                                <div class="h3 mb-0"><?php echo number_format($stats['today_views']); ?></div>
                                <div class="text-muted">今日浏览</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stats-card p-3">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon me-3">
                                <i class="fas fa-users"></i>
                            </div>
                            <div>
                                <div class="h3 mb-0"><?php echo number_format($stats['today_visitors']); ?></div>
                                <div class="text-muted">今日访客</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stats-card p-3">
                        <div class="d-flex align-items-center">
                            <div class="stats-icon me-3">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div>
                                <div class="h3 mb-0"><?php echo number_format($stats['total_visitors']); ?></div>
                                <div class="text-muted">总访客数</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
<div class="image-grid grid-1">
    <div class="image-item">
        <a href="https://fk.xunruanwang.com/jc.mp4" target="_blank"> <!-- 将这里的链接替换为你希望跳转的目标 -->
            <img src="/uploads/jc.png" class="img-fluid" alt="动态图片">
        </a>
    </div>
</div>
            
            

            <?php if (empty($posts)): ?>
            <div class="card">
                <div class="card-body text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">还没有发布任何动态</h5>
                    <p class="mb-3">分享一个动态，看看谁会来访问吧！</p>
                    <a href="/posts/create.php" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i>发布第一条动态
                    </a>
                </div>
            </div>
            <?php else: ?>
                <?php foreach ($posts as $post): ?>
                <div class="card post-card mb-4">
                    <div class="card-body">
                        <a href="/posts/view.php?id=<?php echo $post['id']; ?>" 
                           class="card-link"></a>
                        
                        <div class="d-flex align-items-center mb-3">
                            <img src="<?php echo htmlspecialchars($post['avatar']); ?>" 
                                 class="rounded-circle me-2" 
                                 width="40" height="40" 
                                 alt="<?php echo htmlspecialchars($post['nickname']); ?>">
                            <div>
                                <h6 class="mb-0"><?php echo htmlspecialchars($post['nickname']); ?></h6>
                                <small class="text-muted">
                                    <?php echo date('Y-m-d H:i', strtotime($post['created_at'])); ?>
                                </small>
                            </div>
                        </div>

                        <div class="post-content mb-3">
                            <?php echo nl2br(htmlspecialchars($post['content'])); ?>
                        </div>

                        <?php if ($post['image']): ?>
                        <?php 
                        $images = explode('|', $post['image']);
                        $imageCount = count($images);
                        if ($imageCount > 0):
                        ?>
                        <div class="image-grid grid-<?php echo $imageCount; ?>">
                            <?php foreach ($images as $image): ?>
                            <div class="image-item">
                                <img src="<?php echo htmlspecialchars($image); ?>" 
                                     class="img-fluid" 
                                     alt="动态图片"
                                     onclick="showFullImage('<?php echo htmlspecialchars($image); ?>')">
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted">
                                <i class="fas fa-eye me-1"></i>
                                <?php echo $post['view_count']; ?> 次浏览
                                <span class="mx-2">·</span>
                                <i class="fas fa-user-friends me-1"></i>
                                <?php echo $post['visitor_count']; ?> 位访客
                            </div>
                            <div class="btn-group">
                                <button type="button" 
                                        class="btn btn-sm btn-outline-danger delete-post" 
                                        data-post-id="<?php echo $post['id']; ?>">
                                    <i class="fas fa-trash-alt me-1"></i>删除
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- 图片预览模态框 -->
<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body p-0">
                <img src="" id="modalImage" class="img-fluid w-100">
            </div>
        </div>
    </div>
</div>

<script>
// 图片预览功能
function showFullImage(src) {
    const modal = new bootstrap.Modal(document.getElementById('imageModal'));
    document.getElementById('modalImage').src = src;
    modal.show();
}

// 阻止删除按钮点击事件冒泡
document.querySelectorAll('.delete-post').forEach(button => {
    button.addEventListener('click', function(e) {
        e.stopPropagation(); // 阻止事件冒泡
        if (confirm('确定要删除这条动态吗？')) {
            const postId = this.dataset.postId;
            fetch(`/posts/delete.php?id=${postId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    } else {
                        alert(data.message || '删除失败');
                    }
                });
        }
    });
});
</script>

<?php require_once '../includes/footer.php'; ?> 