<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Post.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => '未登录']);
    exit;
}

// 获取POST数据
$data = json_decode(file_get_contents('php://input'), true);
$postId = isset($data['post_id']) ? (int)$data['post_id'] : 0;

if (!$postId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => '参数错误']);
    exit;
}

try {
    $db = Database::getInstance();
    
    // 检查是否是动态作者
    $sql = "SELECT user_id FROM posts WHERE id = ?";
    $post = $db->query($sql, [$postId])->fetch();
    
    if (!$post || $post['user_id'] != $_SESSION['user']['id']) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => '无权限']);
        exit;
    }
    
    // 检查是否有其他用户访问过
    $sql = "SELECT COUNT(DISTINCT visitor_id) as visitor_count 
            FROM visitors 
            WHERE post_id = ? 
            AND visitor_id != ?";
    $result = $db->query($sql, [$postId, $_SESSION['user']['id']])->fetch();
    
    if ($result['visitor_count'] > 0) {
        // 有其他用户访问过，更新分享状态
        $sql = "UPDATE posts SET 
                share_status = 'shared',
                first_share_time = CASE 
                    WHEN first_share_time IS NULL THEN NOW()
                    ELSE first_share_time
                END
                WHERE id = ?";
        
        $result = $db->query($sql, [$postId]);
        
        if ($result) {
            echo json_encode(['success' => true]);
        } else {
            throw new Exception('更新失败');
        }
    } else {
        // 没有其他用户访问
        echo json_encode([
            'success' => false, 
            'message' => '暂未检测到访客，请确保：\n1. 已经分享到朋友圈\n2. 已有朋友访问过\n如果已经确认分享，请等待朋友访问后再试'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 