<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>服务条款 - 朋友圈访客查询系统</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- 加载动画 -->
    <div class="loading-overlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">加载中...</div>
    </div>

    <div class="policy-page">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center">
                        <h1>服务条款</h1>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">1. 服务说明</h5>
                            <p>朋友圈访客查询系统（以下简称"本系统"）是一个提供朋友圈访客查询服务的平台。通过使用本系统，即表示您同意遵守本服务条款的所有条件和条款。</p>

                            <h5 class="card-title">2. 用户责任</h5>
                            <p>2.1 用户应当遵守中华人民共和国相关法律法规。</p>
                            <p>2.2 用户应当对其账号进行妥善保管，因账号管理不当造成的损失由用户自行承担。</p>
                            <p>2.3 用户在使用本系统时不得从事以下行为：</p>
                            <ul>
                                <li>发布违法、违规或不当信息</li>
                                <li>侵犯他人知识产权或其他合法权益</li>
                                <li>干扰系统正常运行</li>
                                <li>未经授权访问或破坏系统数据</li>
                            </ul>

                            <h5 class="card-title">3. 服务内容</h5>
                            <p>3.1 本系统提供朋友圈访客查询等相关服务。</p>
                            <p>3.2 本系统保留随时修改或中断服务的权利。</p>
                            <p>3.3 本系统不保证服务一定能满足用户的所有需求。</p>

                            <h5 class="card-title">4. 隐私保护</h5>
                            <p>4.1 本系统重视用户隐私保护，具体详见隐私政策。</p>
                            <p>4.2 本系统会采取合理措施保护用户的个人信息。</p>

                            <h5 class="card-title">5. 知识产权</h5>
                            <p>5.1 本系统的所有内容，包括但不限于文本、图片、代码等，均受知识产权法律法规保护。</p>
                            <p>5.2 未经授权，用户不得复制、修改、传播或使用本系统的任何内容。</p>

                            <h5 class="card-title">6. 免责声明</h5>
                            <p>6.1 本系统不对因下列原因导致的任何损失承担责任：</p>
                            <ul>
                                <li>系统停机维护</li>
                                <li>不可抗力因素</li>
                                <li>黑客攻击、计算机病毒侵入</li>
                                <li>用户原因导致的个人信息泄露</li>
                            </ul>

                            <h5 class="card-title">7. 协议修改</h5>
                            <p>7.1 本系统有权随时修改本服务条款的任何内容。</p>
                            <p>7.2 修改后的服务条款将在网站上公布。</p>
                            <p>7.3 如果您不同意修改后的条款，可以停止使用本系统的服务。</p>

                            <h5 class="card-title">8. 法律适用</h5>
                            <p>8.1 本服务条款的解释、效力及纠纷的解决，适用中华人民共和国法律。</p>
                            <p>8.2 若发生任何纠纷，应友好协商解决；协商不成的，任何一方均可向系统运营方所在地人民法院提起诉讼。</p>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="/" class="btn-back">
                            <i class="fas fa-arrow-left"></i>
                            返回首页
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Custom JS -->
    <script src="/assets/js/app.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // 隐藏初始加载动画
        Loading.hide();
    });
    </script>
</body>
</html> 