<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

$pageTitle = '个人资料';
require_once '../includes/header.php';

$user = $_SESSION['user'];
// 获取用户完整信息
$db = Database::getInstance();
$stmt = $db->query("SELECT * FROM users WHERE id = ?", [$user['id']]);
$userInfo = $stmt->fetch();
?>

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="text-center mb-4">
                        <img src="<?php echo htmlspecialchars($user['avatar']); ?>" 
                             class="rounded-circle mb-3" 
                             width="100" height="100" 
                             alt="<?php echo htmlspecialchars($user['nickname']); ?>">
                        <h4><?php echo htmlspecialchars($user['nickname']); ?></h4>
                        <p class="text-muted">
                            <?php echo isset($userInfo['role']) && $userInfo['role'] === 'admin' ? '管理员' : '普通用户'; ?>
                        </p>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">用户ID</label>
                                <input type="text" class="form-control" value="<?php echo $user['id']; ?>" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">OpenID</label>
                                <input type="text" class="form-control" value="<?php echo $user['openid']; ?>" readonly>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="/posts/index.php" class="btn btn-primary">
                            <i class="fas fa-list me-2"></i>我的动态
                        </a>
                        <a href="/auth/logout.php" class="btn btn-danger ms-2">
                            <i class="fas fa-sign-out-alt me-2"></i>退出登录
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?> 