<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';
require_once '../includes/VipCardService.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    die(json_encode(['code' => 1, 'msg' => '请先登录']));
}

// 获取卡密
$cardNo = $_POST['card_no'] ?? '';
if (empty($cardNo)) {
    die(json_encode(['code' => 1, 'msg' => '请输入卡密']));
}

try {
    $cardService = new VipCardService();
    $result = $cardService->useCard($cardNo, $_SESSION['user']['id']);
    
    if ($result['code'] === 0) {
        echo json_encode(['code' => 0, 'msg' => '激活成功']);
    } else {
        echo json_encode(['code' => 1, 'msg' => $result['msg']]);
    }
} catch (Exception $e) {
    echo json_encode(['code' => 1, 'msg' => '系统错误，请重试']);
} 