<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

// 获取订单信息
$orderNo = $_GET['order_no'] ?? '';
$db = Database::getInstance();
$order = $db->query("SELECT * FROM vip_orders WHERE order_no = ? AND status = 'paid' LIMIT 1", 
    [$orderNo])->fetch();

if (!$order) {
    header('Location: /vip/?error=invalid_order');
    exit;
}

// 获取用户VIP信息
$user = new User();
$vipExpireTime = $user->getVipExpireTime();

// 加载页头
require_once '../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <div class="text-success mb-4">
                        <i class="fas fa-check-circle fa-4x"></i>
                    </div>
                    <h3 class="card-title mb-4">支付成功</h3>
                    <p class="text-muted mb-4">
                        您已成功开通VIP会员<br>
                        有效期至：<?php echo date('Y-m-d H:i', strtotime($vipExpireTime)); ?>
                    </p>
                    <div class="d-grid gap-2">
                        <a href="/vip/" class="btn btn-primary">返回会员中心</a>
                        <a href="/" class="btn btn-light">返回首页</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?> 