/*
 * @Date: 2022-10-11 10:15:12
 * @LastEditTime: 2023-03-24 09:55:17
 * @Description: content
 */
import Vue from 'vue'
import App from './App'
import MescrollBody from '@/common/mescroll-uni/mescroll-body.vue'
import Mixin from '@/common/mescroll-uni/mescroll-mixins.js'
import store from 'store'

Vue.config.productionTip = false

/* 引入uview */
import uView from 'uview-ui'
Vue.use(uView)

/* 全局引入copy */
import Copy from './js_sdk/xb-copy/uni-copy'
Vue.prototype.$copy = Copy

/* 引入全局方法 */
import Common from './common/common.js'
Vue.prototype.$common = Common

/* 引入请求方法 */
import request from './common/request'
Vue.prototype.req = request

const baseURL = 'https://1.s480.cn'
const imgURL = 'https://1.s480.cn'

// const baseURL = 'https://chaowutest.languowangluo.com'
// const imgURL = 'https://cwyxxcx.oss-cn-guangzhou.aliyuncs.com'

Vue.prototype.siteBaseUrl = baseURL + '/api'
// Vue.prototype.imgBaseUrl = imgURL + '/chaowu/index'
Vue.prototype.imgBaseUrl = imgURL + '/static/index'
Vue.prototype.imgBaseUrl1 = function () {
  return baseURL + '/static/index'
}

Vue.component('mescroll-body', MescrollBody)
Vue.mixin(Mixin)
App.mpType = 'app'

const app = new Vue({
  ...App,
  store
})
app.$mount()
