<?php

if (!function_exists('filter_str')) {
    /**
     * 过滤空白字符
     *
     * @param  string $str
     */
    function filter_str($str)
    {
        $partern = '/[\x{00a0}\x{1680}\x{2000}-\x{200a}\x{2028}\x{2029}\x{202f}\x{205f}\x{3000}\x{feff}\x{2060}\x{3164}]/u';
        return preg_replace($partern, '', $str);
    }
}

if (!function_exists('writeLog')) {

    /**
     * 日志记录
     * @param string $filename 文件名
     * @param string $content 内容
     */
    function writeLog($filename, $content)
    {
        $path = 'logs/' . $filename;
        if (!is_dir($path)) {
            mkdir($path, 0777, true);
        }
        file_put_contents($path . '/' . date('Y-m-d', time()) . '.txt', date('H:i:s', time()) . "：" . $content . "\r\n", FILE_APPEND);
    }
}

if (!function_exists('randData')) {

    /**
     * 随机抽取（一维数组）
     * @param array     $data       数组
     * @param integer   $num        随机个数
     */
    function randData($data, $num = 1)
    {
        if (!$data) {
            return [];
        }
        // 随机打乱数据
        shuffle($data);
        // 根据抽取个数取指定长度
        $data = array_splice($data, 0, $num);
        return $data;
    }
}
