<?php

namespace App\Http\Controllers\Admin\Admin;

use Illuminate\Http\Request;
use App\Models\Admin\Permission;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Admin\PermissionCreateRequest;

class PermissionController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new Permission();
    }

    /**
     * 权限列表
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        return View::make('admin.admin.permission.index');
    }

    /**
     * 权限数据表格
     * @return \Illuminate\Http\JsonResponse
     */
    public function data()
    {
        $res = $this->model->orderByRaw('sort asc')->get();
        $data = [
            'code' => 0,
            'msg' => '正在请求中...',
            'count' => $res->count(),
            'data' => $res
        ];
        return Response::json($data);
    }

    /**
     * 添加权限
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $model = $this->model;
        $permissions = $this->model->with('allChilds')->orderByRaw('sort asc')->where('parent_id', 0)->get();
        return View::make('admin.admin.permission.create', compact('permissions', 'model'));
    }

    /**
     * 添加权限
     * @param PermissionCreateRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(PermissionCreateRequest $validate)
    {
        $data = $this->request->all();
        if (!$validate->check($data)) {
            return $this->error($validate->getError());
        }
        try {
            $this->model->create($data);
            return $this->success('添加成功!');
        } catch (\Exception $e) {
            return $this->error('添加失败!');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * 更新权限
     * @return \Illuminate\Contracts\View\View
     */
    public function edit()
    {
        $model = $this->model->findOrFail($this->request->id);
        $permissions = $this->model->with('allChilds')->orderByRaw('sort asc')->where('parent_id', 0)->get();
        return View::make('admin.admin.permission.edit', compact('model', 'permissions'));
    }

    /**
     * 更新权限
     * @param PermissionUpdateRequest $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(PermissionCreateRequest $validate)
    {
        $permission = $this->model->findOrFail($this->request->id);
        $data = $this->request->all();
        if (!$validate->check($data)) {
            return $this->error($validate->getError());
        }
        try {
            $permission->update($data);
            return $this->success('更新成功');
        } catch (\Exception $e) {
            return $this->error('更新失败!');
        }
    }

    /**
     * 删除权限
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        $permission = $this->model->with('childs')->find($ids[0]);
        if (!$permission) {
            return $this->error('权限不存在');
        }
        //如果有子权限，则禁止删除
        if ($permission->childs->isNotEmpty()) {
            return $this->error('存在子权限禁止删除');
        }
        try {
            $permission->delete();
            return $this->success('删除成功');
            return Response::json(['code' => 0, 'msg' => '删除成功']);
        } catch (\Exception $e) {
            return $this->error('存在子权限禁止删除');
        }
    }
}
