<?php

namespace App\Http\Controllers\Admin\Admin;

use App\Helpers\OSS\OssClient;
use Exception;
use App\ToolsClass\UploadTool;
use App\Common\Method\Response;
use App\Http\Controllers\BaseController;
use App\Models\Admin\Configuration;

/** 文件上传控制器 */
class UploadsController extends BaseController
{
    /**
     * 上传图片（二进制上传）
     *
     * @param  \App\ToolsClass\UploadTool      $uploadTool
     */
    public function images(UploadTool $uploadTool)
    {
        
        // Base64 数据
        $data = $this->request->input('image');
        $config = new Configuration();
        $URL = '';
        /** 得到文件后缀 */
        //data:image/png;base64,iVBORw0KGgoA..
        list($head,$image_data) = explode(',',$data); // head = data:image/png;base64 image_data = iVBORw0KGgoA..
        list($type,) = explode(';',$head);// type = data:image/png
        list(,$suffix) = explode('/',$type);// suffix = png
        $suffix_arr = explode(',', $config->getVal('storage_image_type'));
        if (!in_array($suffix, $suffix_arr)) {
            return Response::error('不支持' . $suffix . '图片');
        }
        $image_data = str_replace(' ', '+', $image_data);
        /** 步骤1. 输出到本地 */
        $localDir = $_SERVER['DOCUMENT_ROOT'].'/uploads/upload/image';
        $localFilename = $this->makeUUID().'.'.$suffix;
        file_put_contents($localDir.'/'.$localFilename,base64_decode($image_data));

        /** 步骤2. 上传到OSS服务器,得到url */
        try{
            //$this->oss_client->uploadFile 是阿里提供的PHP-SDK中的方法
            $response = $this->storage_save($localDir.'/'.$localFilename);
            $URL = $response['info']['url'];
            return $URL;
        }catch (\Exception $e){
            return $this->error('上传失败');
            // Log::write('文件上传错误:'.$e->getMessage());
            $URL = '';
        } finally {
            /** 步骤3. 删除本地文件 */
            unlink($localDir.'/'.$localFilename);
            return $URL;
        }
        
        return $this->error('请选择图片');
    }
/**
     * 生成uuid (8-4-4-4-12)
     * @return string
     */
    private function makeUUID(){
        $chars = md5(uniqid(mt_rand(), true));
        return substr ( $chars, 0, 8 ) . '-'
            . substr ( $chars, 8, 4 ) . '-'
            . substr ( $chars, 12, 4 ) . '-'
            . substr ( $chars, 16, 4 ) . '-'
            . substr ( $chars, 20, 12 );
    }
    /**
     * 上传图片文件流
     *
     * @param  \App\ToolsClass\UploadTool      $uploadTool
     */
    public function image(UploadTool $uploadTool)
    {
        // 判断是否有上传文件
        $file = $this->request->file('file');
        if ($file && $file->isValid()) {
            //获取文件的绝对路径
            $files = $file->getRealPath();
            try {
                $url =  $uploadTool->curlPic($files, 'upload/admin');
                if (!$url) {
                    return $this->error(Response::getMessage());
                }
                return $this->success("上传成功", ['url' => $url]);
            } catch (Exception $e) {
                return $this->error("上传失败");
            }
        }
        return $this->error("请选择文件");
    }
    function storage_save($srcPath,$newurl = "")
    {
        $newurl = 'aliyun/' . md5(date("Y-m-d H:i:s")).".jpg";
        $configModel = new Configuration();
        //配置
        $accessKeyId  = $configModel->getVal('access_key_id');
        //你的阿里的accessid
        $accessKeySecret  = $configModel->getVal('access_key_secret');
        //你的阿里的accesskey
        $endpoint = $configModel->getVal('endpoint');
        // Endpoint以北京为例，其它Region请按实际情况填写。
        $bucket  = $configModel->getVal('bucket');
        // 存储空间名称
        //
        $object = $newurl;

        $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);//引用
        try {
            $ossClient->setUseSSL(true);
            $res = $ossClient->uploadFile($bucket, $object, $srcPath);
            return $res;
        } catch (OssException $e) {
            print_r($e);
        }//上传
    }
    /**
     * 音频上传
     *
     * @param  \App\ToolsClass\UploadTool $uploadTool
     */
    public function audio(UploadTool $uploadTool)
    {
        // 判断是否有上传文件
        $file = $this->request->file('file');
        if ($file && $file->isValid()) {
            //获取文件的扩展名
            $suffix = $file->extension();
            //获取文件的绝对路径
            $files = $file->getRealPath();
            try {
                $url =  $uploadTool->put(file_get_contents($files), 'upload/admin', '', $suffix, 'audio');
                if (!$url) {
                    return $this->error(Response::getMessage());
                }
                return $this->success("上传成功", ['src' => $url], 0);
            } catch (Exception $e) {
                return $this->error("上传失败");
            }
        }
        return $this->error("请选择文件");
    }

    /**
     * 视频上传
     *
     * @param  \App\ToolsClass\UploadTool $uploadTool
     */
    public function video(UploadTool $uploadTool)
    {
        // 判断是否有上传文件
        $file = $this->request->file('file');
        if ($file && $file->isValid()) {
            //获取文件的扩展名
            $suffix = $file->extension();
            //获取文件的绝对路径
            $files = $file->getRealPath();
            try {
                $url =  $uploadTool->put(file_get_contents($files), 'upload/admin', '',  $suffix, 'video');
                if (!$url) {
                    return $this->error(Response::getMessage());
                }
                return $this->success("上传成功", ['src' => $url], 0);
            } catch (Exception $e) {
                return $this->error("上传失败");
            }
        }
        return $this->error("请选择文件");
    }

    /**
     * 文件上传
     *
     * @param  \App\ToolsClass\UploadTool $uploadTool
     */
    public function file(UploadTool $uploadTool)
    {
        // 判断是否有上传文件
        $file = $this->request->file('file');
        if ($file && $file->isValid()) {
            //获取文件的扩展名
            $suffix = $file->extension();
            //获取文件的绝对路径
            $files = $file->getRealPath();
            try {
                $url =  $uploadTool->put(file_get_contents($files), 'upload/admin', '', $suffix, 'file');
                if (!$url) {
                    return $this->error(Response::getMessage());
                }
                return $this->success("上传成功", ['src' => $url], 0);
            } catch (Exception $e) {
                return $this->error("上传失败");
            }
        }
        return $this->error("请选择文件");
    }
}
