<?php

namespace App\Http\Controllers\Admin\Box;

use View;
use App\Services\Box\BoxModel;
use App\Services\Box\DrawModel;
use App\Services\Box\MarkModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Box\BoxRequest;

// 盒子
class BoxController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new BoxModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.box.box.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        if ($this->request->title) {
            $where[] = ['title', 'like', '%' . $this->request->title . '%'];
        }
        if ($this->request->status) {
            $where[] = ['status', '=', $this->request->status];
        }
        $res = $this->model->where($where)->orderByRaw('sort desc,sales desc,id desc')->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(BoxRequest $validate, MarkModel $markModel, DrawModel $drawModel)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            // 赏类型
            $markList = $markModel->orderByRaw('sort asc,id asc')->get();
            return View::make('admin.box.box.add', compact('model', 'markList'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        // 比例判断
        $mark_rate = $this->request->mark_rate;
        if (!$mark_rate) {
            return $this->error('请填写等级比例');
        }
        foreach ($mark_rate as $k => $v) {
            if ($v < 0) {
                return $this->error('等级比例不能小于0');
            }
            $mark_rate[$k] = formatPrice($v);
        }
        try {
            $model->thumb = $this->request->thumb[0];
            $model->title = $this->request->title;
            $model->price = $this->request->price;
            $model->send_coin = $this->request->send_coin;
            $model->send_money = $this->request->send_money;
            $model->mark_rate = $mark_rate;
            $model->sort = $this->request->sort;
            $model->status = $this->request->status ? 1 : 2;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
      /**
     * 修改状态
     */
    public function show2()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->invite_switch = $model->invite_switch == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }

    /**
     * 修改状态
     */
    public function show3()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->animation = $model->animation == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
