<?php

namespace App\Http\Controllers\Admin\Luckbox;

use View;
use App\Services\Box\MarkModel;
use App\Services\Luckbox\AwardModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Luckbox\AwardRequest;

// 盒子
class AwardController extends BaseController
{
    /** 实例 */
    protected $model;
    protected $markModel;
    protected $mark;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new AwardModel();
        $this->markModel = new MarkModel();
        $this->mark = $this->markModel->orderByRaw('sort asc,id asc')->get();
    }

    /** 列表 */
    public function index()
    {
        // 奖品等级
        $levellist = $this->model::$level;
        // 奖品类型
        $typelist = $this->model::$type;
        return View::make('admin.luckbox.award.index', compact('levellist', 'typelist'));
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        if (isset($this->request->level)) {
            $where[] = ['level', '=', $this->request->level];
        }
        if (isset($this->request->type)) {
            $where[] = ['type', '=', $this->request->type];
        }
        if ($this->request->title) {
            $where[] = ['title', 'like', '%' . $this->request->title . '%'];
        }
        $res = $this->model->with('markinfo')->where($where)->orderByRaw('level asc,mark_id asc,id desc')->paginate($this->request->get('limit', 30));
        if (!$res->isEmpty()) {
            foreach ($res as $v) {
                $v->level_desc = $this->model::$level[$v->level] ?? '';
                $v->type_desc = $this->model::$type[$v->type] ?? '';
            }
        }
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(AwardRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            // 赏类型
            $mark = $this->mark;
            // 奖品等级
            $levellist = $this->model::$level;
            // 奖品类型
            $typelist = $this->model::$type;
            return View::make('admin.luckbox.award.add', compact('model', 'mark', 'levellist', 'typelist'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->type = $this->request->type;
            $model->level = $this->request->level;
            $model->mark_id = $this->request->mark_id;
            $model->title = $this->request->title;
            $model->thumb = $this->request->thumb[0];
            $model->price = $this->request->price;
            $model->real_rate = $this->request->real_rate;
            $model->status = $this->request->status ? 1 : 2;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
