<?php

namespace App\Http\Controllers\Admin\Shop;

use View;
use App\Services\Shop\CatModel;
use App\Services\Shop\SkuModel;
use App\Services\Shop\SpecModel;
use App\Services\Shop\BrandModel;
use App\Services\Shop\GoodsModel;
use App\Services\Shop\SpecValModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Shop\GoodsRequest;
use App\Common\Method\Response as MethodResponse;

class GoodsController extends BaseController
{
    /** 实例 */
    protected $model;
    protected $catModel;
    protected $cat;
    protected $brandModel;
    protected $brand;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new GoodsModel();
        $this->catModel = new CatModel();
        $this->brandModel = new BrandModel();
        $this->cat = $this->catModel->orderByRaw('sort desc')->get();
        $this->brand = $this->brandModel->orderByRaw('sort desc')->get();
    }

    /** 列表 */
    public function index()
    {
        // 分类数据
        $cat = $this->cat;
        // 分类数据
        $brand = $this->brand;
        return View::make('admin.shop.goods.index', compact('cat'));
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 状态筛选
        if ($this->request->cat_id) {
            $where[] = ['cat_id', '=', $this->request->cat_id];
        }
        if ($this->request->status) {
            $where[] = ['status', '=', $this->request->status];
        }
        $res = $this->model->orderByRaw('sort desc,created_at desc')->where($where)
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items(),];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(GoodsRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            // 分类数据
            $cat = $this->cat;
            // 品牌数据
            $brand = $this->brand;
            return View::make('admin.shop.goods.add', compact('model', 'cat', 'brand'));
        }
        // 操作类型
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        //处理 状态 开关数据
        $this->request->offsetSet('status', $this->request->status ? 1 : 2);
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        $result = $this->model->addOrEdit($this->request->all(), $model);
        if (!$result) {
            return $this->error(MethodResponse::getMessage());
        }
        return $this->success('操作成功');
    }

    /**
     * 获取商品规格相关数据
     */
    public function specData()
    {
        $data = [];
        $info = $this->model->where('id', $this->request->product_id)->first();
        if ($info) {
            $result = $this->model->makeSkuTableData($info->toArray());
            $data = $result['specData'];
        }
        return $this->success('请求成功', $data);
    }

    /**
     * 获取商品规格相关数据
     */
    public function skuData()
    {
        $data = [];
        $info = $this->model->where('id', $this->request->product_id)->first();
        if ($info) {
            $result = $this->model->makeSkuTableData($info->toArray());
            $data = $result['skuData'];
        }
        return $this->success('请求成功', $data);
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            // 删除商品
            $this->model->destroy($ids);
            // 清除原来的规格相关数据
            SpecModel::whereIn('goods_id', $ids)->delete();
            SpecValModel::whereIn('goods_id', $ids)->delete();
            SkuModel::whereIn('goods_id', $ids)->delete();
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
