<?php

namespace App\Http\Controllers\Admin\Sys;

use DB;
use View;
use Ifsnop\Mysqldump as IMysqldump;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class BackupController extends BaseController
{
    protected $directory = 'database';

    protected $dir;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        //目录
        $config = config('filesystems.disks.' . $this->directory);
        $dir = $config['root'];
        $this->dir = $dir;
        if (!file_exists($dir)) {
            mkdir($dir, 0777, true);
        }
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.sys.database.index');
    }

    /** 数据 */
    public function data()
    {
        $disk = Storage::disk($this->directory);
        // 获取目录下的文件
        $files = $disk->files();
        $list = [];
        foreach ($files as $k => $v) {
            if (substr($v, strpos($v, '.') + 1) === 'sql') {
                $filename = basename($v);
                $list[$k]['filename'] = str_replace(strrchr($filename, '.'), '', $filename);
                $list[$k]['filesize'] = bytes($disk->size($v)); //文件大小
                $list[$k]['time'] = date('Y-m-d H:i:s', $disk->lastModified($v)); //最后修改时间
            }
            array_multisort(array_column($list, 'time'), SORT_DESC, $list);
        }
        $data = [
            'code' => 0,
            'msg' => '正在请求中...',
            'count' => count($list),
            'data' => $list,
        ];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store()
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            return View::make('admin.sys.database.add');
        }
        try {
            //备份数据库配置
            $dumpSettings = array(
                'compress' => IMysqldump\Mysqldump::NONE,
                'no-data' => false,
                'add-drop-table' => true,
                'single-transaction' => true,
                'lock-tables' => true,
                'add-locks' => true,
                'extended-insert' => true,
                'disable-foreign-keys-check' => true,
                'skip-triggers' => false,
                'add-drop-trigger' => true,
                'databases' => true,
                'add-drop-database' => true,
                'hex-blob' => true
            );
            $dump = new IMysqldump\Mysqldump(
                'mysql:host=' . env('DB_HOST') . ';dbname=' . env('DB_DATABASE'),
                env('DB_USERNAME'),
                env('DB_PASSWORD'),
                $dumpSettings
            );
            $filename = $this->request->filename;
            $filename = $filename . ".sql";
            $dump->start($this->dir . $filename);
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /**
     * 还原备份
     *
     * @return void
     */
    public function before()
    {
        $filename = $this->request->filename;
        $path = $this->dir . $filename . '.sql';
        $exists = file_exists($path);
        if (!$exists) {
            return $this->error('文件不存在');
        }

        //导入sql文件操作
        $sql = file_get_contents($path);
        $result = DB::unprepared($sql);
        if ($result != 1) {
            return $this->error('数据库恢复失败');
        }
        return $this->success('数据库恢复成功');
    }

    /**
     * 删除备份
     *
     * @return void
     */
    public function del()
    {
        $filename = $this->request->filename;
        $path = $this->dir . $filename . '.sql';
        $exists = file_exists($path);
        if (!$exists) {
            return $this->error('文件不存在');
        }
        // 删除单条文件
        $result = unlink($path);
        if ($result) {
            return $this->success('删除成功');
        }
        return $this->error('删除失败');
    }
}
