<?php

namespace App\Http\Controllers\Admin\Users;

use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
use App\Services\User\MoneyLogModel;
use App\Services\User\DailiModel;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class DailiController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new DailiModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.users.daili.index');
    }

    /** 用户数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 状态筛选
        if ($this->request->id) {
            $where[] = ['user_id', '=', $this->request->id];
        }
        if (isset($this->request->status)) {
            $where[] = ['status', '=', $this->request->status];
        }
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start) : 0,
            $end ? strtotime($end) : time(),
        ];
        // 数据
        $res = $this->model->with(['userinfo'])
            ->whereHas('userinfo',function($query){
                if (isset($this->request->mobile)) {
                    $query->where('mobile', $this->request->mobile);
                }
            })
            ->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('id desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 编辑 */
    public function edit()
    {
        $model = $this->model->findOrFail($this->request->id);
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            return View::make('admin.users.daili.edit', compact('model'));
        }
        // 编辑
        $status = $this->request->status;
        if (!in_array($status, [$this->model::STA_1])) {
            return $this->error('请选择状态');
        }
        try {
            // 提现失败
            if ($status == $this->model::STA_1) {
                $usersModel = new UsersModel();
                $user = $usersModel->where('id', $model->user_id)->first();
                $user->level = 3;
                $user->save();
            }
            // 状态改变
            $model->status = $status;
            if (!$model->save()) {
                return $this->error('修改失败!');
            }
            DB::commit();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            DB::rollBack();
            return $this->error('操作失败!');
        }
    }
}
