<?php

namespace App\Http\Controllers\Admin\Users;

use App\Services\Order\ShipModel;
use App\Services\User\UsersModel;
use App\Services\Ship\ShipListModel;
use Illuminate\Support\Facades\View;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Users\ShipRequest;
use App\Services\Order\DeliveryModel;

class ShipController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new OrderListModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.users.ship.index');
    }

    /** 用户数据 */
    public function data()
    {
        // 筛选
        // $where = [
        //     ['status', '=', $this->model::STA_1],
        // ];
        $where = [];
        // 状态筛选
        if ($this->request->id) {
            $where[] = ['user_id', '=', $this->request->id];
        }
        if (isset($this->request->status)) {
            $where[] = ['status', '=', $this->request->status];
        }else{
            $where[] = ['status', '=', $this->model::STA_1];
        }
        // 时间筛选
        $time = [0, time()];
        $start_time = $this->request->start_time;   //开始时间
        $end_time = $this->request->end_time;       //截至时间
        if ($start_time) {
            $time[0] = strtotime($start_time);
        }
        if ($end_time) {
            $time[1] = strtotime($end_time);
        }
        // 数据
        $res = $this->model->with(['userinfo', 'shipinfo'])
            ->whereHas('userinfo', function ($query) {
                if (isset($this->request->mobile)) {
                    $query->where('mobile', $this->request->mobile);
                }
            })
            ->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('updated_at desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 编辑 */
    public function edit(ShipRequest $validate)
    {
        $model = $this->model->where(['id' => $this->request->id])->first();
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            // 快递信息
            $delivery = DeliveryModel::get();
            return View::make('admin.users.ship.edit', compact('model', 'delivery'));
        }
        // 验证
        if (!$validate->scene('send')->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        $delivery_id = $this->request->delivery_id;
        $delivery = DeliveryModel::findOrFail($delivery_id);
        $shipinfo = $model->shipinfo;
        // 修改
        $shipinfo->express_name = $delivery->name;
        if ($model->status == $this->model::STA_1) {
            $model->status = $this->model::STA_2;
        }
        $shipinfo->express_code = $delivery->code;
        $shipinfo->express_num = $this->request->express_num;
        $shipinfo->name = $this->request->name;
        $shipinfo->mobile = $this->request->mobile;
        $shipinfo->address = $this->request->address;
        if ($shipinfo->save() && $model->save()) {
            return $this->success('发货成功');
        }
        return $this->error('发货失败');
    }
}
