<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\Order\OrderModel;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\AwardListResources;
use App\Http\Resources\Box\OrderAwardResources;
use App\Services\Box\AwardModel;
use App\Models\Admin\Configuration;
class AwardController extends BaseController
{
    /**
     * 获取抽奖的奖品
     *
     * @param  \App\Services\Order\OrderModel     $orderModel
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function list(
        OrderModel $orderModel,
        OrderListModel $model,
        AwardModel $awardModel
    ) {
        // 筛选
        $order = $orderModel->where('order_sn', $this->request->order_sn)->first();
        $configModel = new Configuration();
        $where = [
            ['order_id', '=', $order->id],
            ['user_id', '=', $order->user_id],
        ];
        $list = $model->where($where)->orderByRaw('id desc')->get();
        $goodsIds = array_column($list->toArray(),'goods_id');
        $goodsList = $awardModel->whereIn('id',$goodsIds)->get();
        foreach ($list as &$value) {
            foreach ($goodsList as $goods){
                if($value['goods_id'] == $goods['id']){
                    $value['dissolve_price'] = bcmul($value->price,bcdiv($goods->dissolve_rate,100,2),2);
                    $value['editor'] = $goods->editor;
                    $value['show_rate'] = $goods->show_rate;
                    // $value['mark_title'] = $goods->markinfo->mark_title;
                    // $value['mark_color'] = $goods->markinfo->mark_color;
                }
            }
            
        }
        $list = OrderAwardResources::collection($list);
        return $this->success('请求成功', $list);
    }

    /**
     * 盒子奖品
     *
     * @param  \App\Services\Order\OrderModel     $orderModel
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function award(AwardModel $awardModel)
    {
        $where = [
            ['box_id', '=', $this->request->box_id],
        ];
        if ($this->request->mark_id) {
            $where[] = ['mark_id', '=', $this->request->mark_id];
        }
        $awardList = $awardModel->where($where)
            ->orderByRaw('mark_id asc,id desc')
            ->paginate($this->request->per_page);
        $awardList = $awardModel->page($awardList);
        $awardList['data'] = AwardListResources::collection($awardList['data']);
        $awardList['totals'] = $awardModel->where('box_id', $this->request->box_id)->count();
        return $this->success('请求成功', $awardList);
    }
}
