<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\User\FriendModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Redpack\LogResources;

class FriendController extends BaseController
{
    /**
     * 开启红包记录
     *
     * @param  \App\Services\User\FriendModel $friendModel
     */
    public function list(FriendModel $friendModel)
    {
        $user = auth('api')->user();
        $list = $friendModel->where(['user_id' => $user->id])
            ->orderByRaw('id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $friendModel->page($list);
        $list['data'] = LogResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
