<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\Box\MarkModel;
use App\Http\Controllers\BaseController;

class MarkController extends BaseController
{
    /**
     * 赏等级
     *
     * @param  \App\Services\Box\MarkModel $markModel
     */
    public function list(MarkModel $markModel)
    {
        $list = $markModel->select(['id', 'title'])
            ->orderByRaw('sort asc,id desc')
            ->get()
            ->toArray();
        array_unshift($list, ['id' => '', 'title' => '全部']);
        return $this->success('请求成功', $list);
    }
}
