<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\Box\BoxModel;
use App\Common\Method\Response;
use App\Services\Box\RatingModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\RatingResources;

class RatingController extends BaseController
{
    /**
     * 评价奖品
     *
     * @param  \App\Services\Box\RatingModel $ratingModel
     * @param  \App\Services\Box\BoxModel    $boxModel
     */
    public function list(RatingModel $ratingModel, BoxModel $boxModel)
    {
        // 盒子数据
        $box = $boxModel->getFind($this->request->id);
        if (!$box) {
            return $this->error(Response::getMessage());
        }
        $where = [
            ['box_id', '=', $box->id],
        ];
        $list = $ratingModel->where($where)
            ->orderByRaw('id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $ratingModel->page($list);
        $list['data'] = RatingResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
