<?php

namespace App\Http\Controllers\Api\V1\Complain;

use App\Services\Complain\TypeModel;
use App\Http\Controllers\BaseController;
use App\Services\Complain\ComplainModel;
use App\Http\Requests\Api\Complain\ComplainRequest;

class ComplainController extends BaseController
{
    /**
     * 投诉提交
     *
     * @param  \App\Services\Complain\TypeModel                $typeModel
     * @param  \App\Http\Requests\Api\Complain\ComplainRequest $validate
     * @param  \App\Services\Complain\ComplainModel            $complainModel
     */
    public function add(
        TypeModel $typeModel,
        ComplainRequest $validate,
        ComplainModel $complainModel
    ) {
        $user = auth('api')->user();
        // 验证
        if (!$validate->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        // 问题类型
        $type = $typeModel->where('id', $this->request->type_id)->first();
        if (!$type) {
            return $this->error('问题类型选择不正确!');
        }
        // 添加
        $log = $complainModel;
        $log->user_id = $user->id;
        $log->title = $type->title;
        $log->mobile = $this->request->mobile;
        $log->content = $this->request->content;
        $log->thumb = $this->request->thumb;
        if (!$log->save()) {
            return $this->error('提价失败!');
        }
        return $this->success('提交成功');
    }
}
