<?php

namespace App\Http\Controllers\Api\V1\Complain;

use App\Http\Controllers\BaseController;
use App\Services\Complain\ComplainModel;
use App\Http\Resources\Complain\LogResources;

class LogController extends BaseController
{
    /**
     * 投诉记录
     *
     * @param  \App\Services\Complain\ComplainModel $complainModel
     */
    public function list(ComplainModel $complainModel)
    {
        $user = auth('api')->user();
        $list = $complainModel->where(['user_id' => $user->id])
            ->orderByRaw('id desc')
            ->paginate($this->request->per_pag ?? 20);
        $list = $complainModel->page($list);
        $list['data'] = LogResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
