<?php

namespace App\Http\Controllers\Api\V1\Index;

use App\Models\Admin\Configuration;
use App\Http\Controllers\BaseController;

// 配置
class ConfigController extends BaseController
{
    /**
     * 全局配置
     *
     * @param  \App\Models\Admin\Configuration $config
     */

    public function global(Configuration $config)
    {
        // 配置字段
        $field = [
            'app_logo',                                         // logo
            'withdraw_handling_rate',                           // 提现手续费比例
            'withdraw_day_max',                                 // 提现今日最大上限
            'site_title',                                       // 系统名称
            'share_bg',                                         // 邀请背景图
            'poster_bg',                                        // 邀请海报背景图
            'pop_con',                                          //公告
            'is_wechat_payment_enabl',
            'is_ali_payment_enabl',
            'fraudulent_review_switch',
            'fraudulent_review_url',
            'is_golden_egg',
            'golden_egg_id',
            'is_golden_rj',                                     // 溶解开关
        ];
        $data = $config->getVal($field);
        return $this->success('请求成功', $data);
    }

    /**
     * 红包配置
     *
     * @param  \App\Models\Admin\Configuration $config
     * @param  \App\Models\Admin\Configuration $configuration
     */
    public function redpack(Configuration $config)
    {
        $user = auth('api')->user();
        // 配置字段
        $field = [
            'open_redpack_coin',                                        // 红包所需积分
            'redpack_max_money',                                        // 最大可开红包金额
        ];
        $data = $config->getVal($field);
        // 获取可开红包次数
        $data['coin'] = $user->userinfo->coin;                          // 积分
        $redpack_need = $config->getVal('open_redpack_coin') ?? 200;
        $redpack_times = calc($data['coin'], '/', $redpack_need, 0);
        $data['redpack_times'] = $redpack_times;                        // 获取可开红包次数
        return $this->success('请求成功', $data);
    }
}
