<?php

namespace App\Http\Controllers\Api\V1\Index;

use App\Helpers\OSS\OssClient;
use App\Models\Admin\Configuration;
use Exception;
use App\ToolsClass\UploadTool;
use App\Http\Controllers\BaseController;

/** 文件上传控制器 */
class UploadsController extends BaseController
{
    /**
     * 图片上传
     *
     * @param  \App\ToolsClass\UploadTool $uploadTool
     */
    public function image(UploadTool $uploadTool)
    {
        // 判断是否有上传文件
        $file = $this->request->file('image');
        if ($file && $file->isValid()) {
            //获取文件的扩展名
            $suffix = $file->extension();
            //获取文件的绝对路径
            $files = $file->getRealPath();
            try {
                $response = $this->storage_save($files);
                $url = $response['info']['url'];
                return $this->success("上传成功", $url);
            } catch (Exception $e) {
                return $this->error("上传失败");
            }
        }
        return $this->error("请选择文件");
    }
    function storage_save($srcPath,$newurl = "")
    {
        $newurl = 'aliyun/' . md5(date("Y-m-d H:i:s")).".jpg";
        $configModel = new Configuration();
        //配置
        $accessKeyId  = $configModel->getVal('access_key_id');
        //你的阿里的accessid
        $accessKeySecret  = $configModel->getVal('access_key_secret');
        //你的阿里的accesskey
        $endpoint = $configModel->getVal('endpoint');
        // Endpoint以北京为例，其它Region请按实际情况填写。
        $bucket  = $configModel->getVal('bucket');
        // 存储空间名称
        //
        $object = $newurl;

        $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);//引用
        try {
            $ossClient->setUseSSL(true);
            $res = $ossClient->uploadFile($bucket, $object, $srcPath);
            return $res;
        } catch (OssException $e) {
            \Log::error('OSS上传异常: ' . $e->getMessage());
            throw $e;
        }//上传
    }
}
