<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Services\User\InfoModel;
use App\Services\Luckbox\NumModel;
use App\Models\Admin\Configuration;
use App\Services\Luckbox\JoinModel;
use App\Services\Luckbox\TermModel;
use App\Services\Luckbox\AwardModel;
use App\Services\Luckbox\NoticeModel;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\AwardListResources;

class BoxController extends BaseController
{
    /**
     * 幸运盲盒首页
     *
     * @param  \App\Services\Luckbox\TermModel  $termModel
     * @param  \App\Models\Admin\Configuration  $config
     * @param  \App\Services\Luckbox\AwardModel $awardModel
     * @param  \App\Services\Luckbox\NumModel   $numModel
     * @param  \App\Services\Luckbox\JoinModel  $joinModel
     * @param  \App\Services\User\InfoModel     $infoModel
     */
    public function index(
        TermModel $termModel,
        Configuration $config,
        AwardModel $awardModel,
        NumModel $numModel,
        JoinModel $joinModel,
        InfoModel $infoModel,
        NoticeModel $noticeModel,
        OrderListModel $orderListModel
    ) {
        $user = auth('api')->user();
        // 最新进行中的
        $info = $termModel->where(['status' => $termModel::STA_0])->orderByRaw('id desc')->first();
        $data['term']['term_id'] = $info->id;
        $data['term']['title'] = $info->title;
        $data['term']['need_coin'] = $config->getVal('luckbox_need_coin');
        $data['term']['hiden_need'] = $config->getVal('luckbox_hiden_need');
        $luckbox_progress = 0;
        if ($user) {
            $luckbox_progress = $infoModel->luckprogress($user, $info->id);
        }
        $data['term']['luckbox_progress'] = $luckbox_progress;
        $data['term']['end_time'] = $info->end_time - time();
        $data['term']['end_times'] = $info->end_time;
        // 隐藏奖品
        $list = $awardModel->factor()
            ->where('level',  $awardModel::LEVEL_2)
            ->orderByRaw('mark_id asc,id desc')
            ->get();
        $data['hiden_award'] = AwardListResources::collection($list);
        // 数字数据
        $numberList = $numModel->get();
        if (!$numberList->isEmpty()) {
            foreach ($numberList as $v) {
                $v->buy_num = 0;
                if ($user) {
                    $log = $joinModel->where(['user_id' => $user->id, 'term_id' => $info->id, 'number' => $v->number])->first();
                    if ($log) {
                        $v->buy_num = $log->num;
                    }
                }
            }
        }
        $data['number'] = $numberList;
        // 上期数据
        $data['last'] = null;
        $last = $termModel->where(['status' => $termModel::STA_1])->orderByRaw('id desc')->first();
        if ($last) {
            $data['last']['luck_number'] = $last->luck_number;
            $data['last']['title'] = $last->title;
            $data['last']['join_num'] = $last->join_num;
            $data['last']['award'] = null;
            $where = [
                ['type', '=', $orderListModel::TYPE_2],
                ['get_type', '=', $orderListModel::G_TYPE_2],
                ['data_id', '=', $last->id],
            ];
            $award = $orderListModel->where($where)->first();
            if ($award) {
                $data['last']['award']['nickName'] = $award->userinfo->nickName;
                $data['last']['award']['title'] = $award->title;
                $data['last']['award']['thumb'] = $award->thumb;
                $data['last']['award']['price'] = $award->price;
            }
        }
        // 上期中奖数据
        $data['notice'] = null;
        $is_notice = $noticeModel->where(['user_id' => $user->id, 'is_notice' => 2])->orderByRaw('id desc')->first();
        if ($is_notice) {
            $data['notice'] = $termModel->info($user, $is_notice->term_id);
            // 修改查看状态
            $is_notice->is_notice = 1;
            $is_notice->save();
        }
        return $this->success('请求成功', $data);
    }
}
