<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use Exception;
use App\Common\Method\Response;
use App\Services\Luckbox\NumModel;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\Configuration;
use App\Services\Luckbox\JoinModel;
use App\Services\Luckbox\TermModel;
use App\Services\User\CoinLogModel;
use App\Http\Controllers\BaseController;
use App\Http\Requests\Api\Luckbox\JoinRequest;
use App\Services\User\TreeModel;
use App\Services\User\UsersModel;

class JoinController extends BaseController
{
    public function join(
        JoinModel $joinModel,
        NumModel $numModel,
        TermModel $termModel,
        JoinRequest $validate,
        Configuration $config,
        CoinLogModel $coinLogModel,
        TreeModel $treeModel,
        UsersModel $usersModel
    ) {
        $user = auth('api')->user();
        $num = $this->request->num;
        $number = $this->request->number;
        if (!$validate->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        // 本期数据
        $term = $termModel->getFirst($this->request->term_id);
        if (!$term) {
            return $this->error(Response::getMessage());
        }
        // 盲盒编号判断
        $numData = $numModel->where('number', $number)->first();
        if (!$numData) {
            return $this->error('盲盒编号选择不正确!');
        }
        // 种类判断（编号选择不超过五种）
        $number_List = $joinModel->where(['term_id' => $term->id, 'user_id' => $user->id])->groupBy('number')->get();
        if ($number_List->count() >= $joinModel::NUMBER_MAX) {
            return $this->error('最多兑换五种不同的盲盒!');
        }
        DB::beginTransaction();
        try {
            // 获取该期购买次数
            $count = $joinModel->where(['user_id' => $user->id, 'term_id' => $term->id])->count();
            // 购买编号
            $price = $config->getVal('luckbox_need_coin') ?? 6;
            $coin = calc($price, '*', $num);
            if ($coin > $user->userinfo->coin) {
                return $this->error('积分不足!');
            }
            $res = $joinModel->join($user, $term, $number, $num);
            // 积分减少
            $coinRes = $coinLogModel->log($user->userinfo, -$coin, $coinLogModel::TYPE_3, '幸运盲盒第' . $term->title . '期兑换');
            if (!$res || !$coinRes) {
                DB::rollBack();
                return $this->error('兑换失败!');
            }
            // 判断本期是否参与过
            if ($count <= 0) {
                // 判断有没有上级并且返积分次数
                $tree = $treeModel->where('user_id', $user->id)->first();
                if ($tree && $tree->parent_id > 0 && $tree->return_times > 0) {
                    $parent = $usersModel->where('id', $tree->parent_id)->first();
                    if ($parent) {
                        // 赠送积分
                        $sendCoin = mt_rand(1, $termModel::INVITE_USER_POINTS_MAX);
                        $coinRes = $coinLogModel->log($parent->userinfo, $sendCoin, $coinLogModel::TYPE_5, '用户' . $user->nickName . '选盒');
                        // 次数减少
                        $tree->return_times -= 1;
                        if (!$tree->save() || !$coinRes) {
                            DB::rollBack();
                            return $this->error('兑换失败!');
                        }
                    }
                }
            }
            DB::commit();
            return $this->success('兑换成功', $number);
        } catch (Exception $e) {
            DB::rollBack();
            return $this->error('请求失败!');
        }
    }
}
