<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Common\Method\Response;
use App\Services\Luckbox\SignModel;
use App\Services\Luckbox\TermModel;
use App\Http\Controllers\BaseController;

class TaskController extends BaseController
{
    /**
     * 积分任务
     *
     * @param  \App\Services\Luckbox\TermModel $termModel
     * @param  \App\Services\Luckbox\SignModel $signModel
     */
    public function index(TermModel $termModel, SignModel $signModel)
    {
        $user = auth('api')->user();
        // 本期数据
        $term = $termModel->getFirst($this->request->term_id);
        if (!$term) {
            return $this->error(Response::getMessage());
        }
        $data['is_sign'] = $signModel->isSign($user, $term) ? 1 : 2;
        $data['sign_times'] = $termModel::SING_TIMES;
        $data['sign_points_min'] = $termModel::SING_POINTS_MIN;
        $data['sign_points_max'] = $termModel::SING_POINTS_MAX;
        $data['invite_user_times'] = $termModel::INVITE_USER_TIMES;
        $data['invite_user_get_points'] = calc($termModel::INVITE_USER_TIMES, '*', $termModel::INVITE_USER_POINTS_MAX, 0);
        $data['invite_open_box_piints_max'] = $termModel::INVITE_OPEN_BOX_POINTS_MAX;
        return $this->success('请求成功', $data);
    }
}
