<?php

namespace App\Http\Controllers\Api\V1\Pay;

use App\ToolsClass\AliPay\AliPayTool;
use Exception;
use App\Common\Method\Response;
use App\Services\User\UsersModel;
use App\Services\User\RechargeLogModel;
use App\Services\Order\OrderModel;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\ToolsClass\WxPay\MiniPayTool;
use App\Http\Controllers\BaseController;
use App\Models\Admin\Configuration;
class PayController extends BaseController
{
    /**
     * 支付
     *
     * @param OrderModel $orderModel
     * @param MiniPayTool $wxPay
     * @param AliPayTool $aliPay
     * @param UsersModel $users
     * @param RechargeLogModel $rechargeLogModel
     * @return JsonResponse|void
     */
    public function Pay(
        OrderModel $orderModel,
        MiniPayTool $wxPay,
        AliPayTool $aliPay,
        UsersModel $users,
        RechargeLogModel $rechargeLogModel
    ) {
        // 订单判断
        $order = $orderModel->where(['order_sn' => $this->request->order_sn])->first();
        $rechargeOrder = $rechargeLogModel->where(['out_trade_no'=>$this->request->order_sn])->first();
        if(!empty($order)){
            if ($order->status != $orderModel::STA_0) {
                return $this->error('订单不存在或已支付!');
            }
            $user = $users->where(['id' => $order->user_id])->first();
            if ($order->pay_money < 0.01) {
                return $this->error('该金额不足0.01元无法支付');
            }
            // 微信支付
            if ($order->pay_type == $orderModel::P_TYPE_3) {
                $data = [
                    'total_fee' => (($order->pay_money) -mt_rand(Configuration::getVal('wx_pay_amount_min'),Configuration::getVal('wx_pay_amount_max'))/100),
                    'out_trade_no' => $order->order_sn,
                    'body' => $order->data['title'] ?? '微信支付',
                    'openid' => $user->openid
                ];
                $pay_data = $wxPay->pay($data);
            }
            if($order->pay_type == $orderModel::P_TYPE_4){

                $data = [
                    'out_trade_no' => $order->order_sn,
                    'total_amount' => $order->pay_money,
                    'subject'      => $order->data['title'] ?? '支付宝支付',
                ];
                $pay_data = $aliPay->pay($data);
            }
            if (!$pay_data) {
                return $this->error(Response::getMessage());
            }
            return $this->success('请求成功', ['pay_type' => $order->pay_type, 'data' => $pay_data,]);
        }else if(!empty($rechargeOrder)){
            if ($rechargeOrder->status != $orderModel::STA_0) {
                return $this->error('订单不存在或已支付!');
            }
            $user = $users->where(['id' => $rechargeOrder->user_id])->first();
            if ($rechargeOrder->pay_money < 0.01) {
                return $this->error('该金额不足0.01元无法支付');
            }
            // 微信支付
            $data = [
                'total_fee' => $order->pay_money,
                'out_trade_no' => $rechargeOrder->out_trade_no,
                'body' => '充值余额',
                'openid' => $user->openid
            ];
            $pay_data = $wxPay->pay($data);

            if (!$pay_data) {
                return $this->error(Response::getMessage());
            }
            return $this->success('请求成功', ['pay_type'=>3,'data' => $pay_data]);
        }
    }
    /**
     * 充值支付
     *
     * @param  \App\Services\User\RechargeLogModel    $rechargeLogModel
     * @param  \App\ToolsClass\WxPay\MiniPayTool $wxPay
     * @param  \App\Services\User\UsersModel     $users
     */
    public function RechargePay(
        RechargeLogModel $rechargeLogModel,
        MiniPayTool $wxPay,
        UsersModel $users
    ) {
        // 订单判断
        $order = $rechargeLogModel->where(['out_trade_no' => $this->request->out_trade_no])->first();
        if (!$order || $order->status != $rechargeLogModel::STA_0) {
            return $this->error('订单不存在或已支付!');
        }
        $user = $users->where(['id' => $order->user_id])->first();
        if ($order->pay_money < 0.01) {
            return $this->error('该金额不足0.01元无法支付');
        }

    }
    /**
     * 订单取消
     *
     * @param  \App\Services\Order\OrderModel $orderModel
     */
    public function cancel(OrderModel $orderModel)
    {
        // 订单判断
        $order = $orderModel->where(['order_sn' => $this->request->order_sn])->first();
        if (!$order || $order->status != $orderModel::STA_0) {
            return $this->error('订单不存在或已支付!');
        }
        DB::beginTransaction();
        try {
            $result = $orderModel->cancelPay($order);
            if (!$result) {
                DB::rollBack();
                return $this->error('取消失败!');
            }
            DB::commit();
            return $this->success('取消成功!');
        } catch (Exception $e) {
            DB::rollBack();
            return $this->error('操作失败!');
        }
    }
}
