<?php

namespace App\Http\Controllers\Api\V1\Pay;

use App\Services\Order\OrderModel;
use App\Services\User\GoldLogModel;
use App\Services\User\BindLogModel;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
use App\ToolsClass\WxPay\MiniPayTool;
use App\Http\Controllers\BaseController;
use App\Models\Admin\Configuration;
use App\Services\User\RechargeLogModel;
class WxNotifyController extends BaseController
{
    /**
     * 支付回调
     *
     * @param  \App\ToolsClass\WxPay\MiniPayTool $pay
     * @param  \App\Services\Order\OrderModel    $orderModel
     */
    public function notify(
        MiniPayTool $pay,
        OrderModel $orderModel,
        RechargeLogModel $rechargeLogModel
    ) {
        // 验签回调信息
        $message = $pay->app->verify();
        //订单不存在或者订单已支付
        $order = $orderModel->where(['order_sn' => $message['out_trade_no']])->first();
        $rechargeOrder = $rechargeLogModel->where(['out_trade_no'=>$message['out_trade_no']])->first();
        if(!empty($order)){
            if ($order->status != $orderModel::STA_0) {
                return $pay->app->success();
            }
            if ($message['return_code'] == 'SUCCESS') {
                // 用户支付成功
                if ($message['result_code'] == 'SUCCESS') {
                    // 回调
                    DB::beginTransaction();
                    try {
                        $notifyRes = $orderModel->notify($order);
                        if (!$notifyRes) {
                            // 回调失败退款
                            Db::rollBack();
                            $order->transaction_id = $message['transaction_id'];    // 订单号
                            $order->status = $orderModel::STA_1;                    // 支付成功
                            $order->is_refund = $orderModel::REF_1;                 // 待退款
                            $order->save();
                        } else {
                            $order->transaction_id = $message['transaction_id'];    // 订单号
                            $order->save();
                            
                            // 【已删除】原来这里有重复的佣金发放代码（第 57-84 行）
                            // 现在佣金发放统一在 BoxModel::notify 里处理，支持次数限制、Redis 锁、防并发
                            
                            DB::commit();
                        }
                        return $pay->app->success();
                    } catch (\Exception $e) {
                        Db::rollBack();
                        DB::table('test')->insert(['value' => $e]);
                    }
                }
            }
        }else{
            if ($rechargeOrder->status != $rechargeOrder::STA_0) {
                return $pay->app->success();
            }
            if($message['return_code'] == 'SUCCESS'){
                if($message['result_code'] == 'SUCCESS'){
                    DB::beginTransaction();
                    try {
                        $notifyRes = $rechargeLogModel->notify($rechargeOrder);
                        $rechargeLogModel->transaction_id = $message['transaction_id'];    // 订单号
                        $rechargeLogModel->save();
                        DB::commit();
                        return $pay->app->success();
                    } catch (\Exception $e) {
                        Db::rollBack();
                        DB::table('test')->insert(['value' => 'cz='.$e]);
                    }
                }
            }
        }
    }
}
