<?php

namespace App\Http\Controllers\Api\V1\Redpack;

use Exception;
use App\ToolsClass\RedisTool;
use App\Common\Enum\RedisEnum;
use App\Common\Method\Response;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\Configuration;
use App\Services\Operate\RedpackModel;
use App\Http\Controllers\BaseController;

class OpenController extends BaseController
{
    /**
     * 开启红包
     *
     * @param  \App\Services\Operate\RedpackModel $redpackModel
     * @param  \App\Models\Admin\Configuration    $configuration
     * @param  \App\ToolsClass\RedisTool          $redis
     */
    public function open(
        RedpackModel $redpackModel,
        Configuration $configuration,
        RedisTool $redis
    ) {
        $user = auth('api')->user();
        $need = $configuration->getVal('open_redpack_coin') ?? 200;
        $key = RedisEnum::OPEN_REDPACK . $user->id;
        if ($redis->block($key)) {
            // 判断积分是否够
            if ($user->userinfo->coin < $need) {
                return $this->unlock($redis, $key)->error('积分不足!');
            }
            DB::beginTransaction();
            try {
                // 开红包
                $res = $redpackModel->open($user, $need);
                if (!$res) {
                    DB::rollBack();
                    return $this->unlock($redis, $key)->error(Response::getMessage());
                }
                DB::commit();
                return $this->unlock($redis, $key)->success('开启成功', ['money' => $res->money]);
            } catch (Exception $e) {
                DB::rollBack();
                dd($e);
                return $this->unlock($redis, $key)->error('操作失败!');
            }
        }
        return $this->error('操作过快,请重试!');
    }
}
