<?php

namespace App\Http\Controllers\Api\V1\Shop;

use App\Services\Shop\ChangeModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Shop\ChangeInfoResources;
use App\Http\Resources\Shop\ChangeListResources;

class ChangeController extends BaseController
{
    /**
     * 商品列表
     *
     * @param  \App\Services\Shop\ChangeModel $model
     */
    public function list(ChangeModel $model)
    {
        // 筛选条件
        $where = [];
        $money = $this->request->money;
        if ($money) {
            $money = calc($money, '*', 1.2);    // 置换价格小于120%
            $where[] = ['price', '<=', $money];
        }
        $list = $model->factor()
            ->where($where)
            ->orderByRaw('sort desc,id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $model->page($list);
        $list['data'] = ChangeListResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 商品详情
     *
     * @param  \App\Services\Shop\ChangeModel $model
     */
    public function info(ChangeModel $model)
    {
        $data = $model->factor()->where('id', $this->request->id)->first();
        if (!$data) {
            return $this->error('商品不存在或已下架!');
        }
        $data = new ChangeInfoResources($data);
        return $this->success('请求成功', $data);
    }
}
