<?php

namespace App\Http\Controllers\Api\V1\Sms;

use App\Common\Method\Response;
use App\Services\Sms\SmsLogModel;
use App\Http\Requests\Api\Sms\SmsRequest;
use App\Http\Controllers\BaseController;

class SmsController extends BaseController
{
    /**
     * 短信发送 （无token)
     *
     * @param  \App\Http\Requests\Api\User\SmsRequest $validate
     * @param  \App\Services\User\SmsLogModel    $smslog
     */
    public function send(SmsRequest $validate, SmsLogModel $smslog)
    {
        // 参数验证
        if (!$validate->scene('send')->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        // 发送短信
        $data = [];
        $result = $smslog->send($this->request->mobile, $this->request->type);
        if (!$result) {
            return $this->error(Response::getMessage());
        }
        if (!$result['switch']) {
            $data = ['code' => $result['code']];
        }
        return $this->success('发送成功', $data);
    }
}
