<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Services\User\BindLogModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\User\BindResources;

class BindController extends BaseController
{
    /**
     * 邀请记录
     *
     * @param  \App\Services\User\BindLogModel $bindLogModel
     */
    public function list(BindLogModel $bindLogModel)
    {
        $user = auth('api')->user();
        $list = $bindLogModel->where(['parent_id' => $user->id])
            ->orderByRaw('created_at desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $bindLogModel->page($list);
        $list['data'] = BindResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
