<?php

namespace App\Http\Controllers\Api\V1\User;

use Exception;
use App\Common\Method\Response;
use App\Services\User\UsersModel;
use App\Http\Controllers\BaseController;
use App\Services\Order\OrderModel;
use Illuminate\Support\Facades\DB;
use App\Services\Box\BoxModel;
use App\Models\Admin\Configuration;
use Symfony\Component\Cache\Adapter\RedisAdapter;
use EasyWeChat\Factory;
use App\ToolsClass\WeChat\MiniProgramTool;
use Illuminate\Http\Request;
use App\Services\Order\OrderListModel;

/** 登录 */
class LoginController extends BaseController
{
        /**
     * @var string TOKEN
     */
    public $token;
        /**
     * @var string 小程序APPID
     */
    private $appid;
    /**
     * @var string 小程序APPSECRET
     */
    private $appsecret;

    public function __construct()
    {
        $configModel = new Configuration();
        $this->appid = $configModel->getVal('mini_appid');
        $this->appsecret = $configModel->getVal('mini_secret');
        // $miniProgramTool = new MiniProgramTool();
        $this->token = $this->get_access_token();
    }
    /**
     * 小程序获取用户信息登录(前端把用户信息和Code传过来)POST
     *
     * @param  \App\ToolsClass\WeChat\MiniProgramTool $miniProgramTool
     * @param  \App\Services\User\UsersModel          $usersModel
     */
    public function login(
        MiniProgramTool $miniProgramTool,
        UsersModel $usersModel
    ) {
        // 用户信息
        $code = $this->request->code;
        $data = $miniProgramTool->sessionKey($code);
        if (!$data) {
            return $this->error(Response::getMessage());
        }
        $user = $usersModel->where('openid', $data['openid'])->first();
        if (!$user) {
            return $this->error('请先注册!', [], 1001);
        }
        $token = auth('api')->login($user);
        $data = $usersModel->respondWithToken($user, $token);
        return $this->success('登录成功', $data);
    }

    /**
     * 测试用户登录
     *
     * @param  \App\Services\User\UsersModel $usersModel
     */
    public function testLogin(
        UsersModel $usersModel
    ) {
        $md5 = $this->request->md5;
        if ($md5 != 'a25d3e45132b010b0b8d181bc1132c73b4624095') {
            return $this->error('FAIL');
        }
        $user = $usersModel->where('id', $this->request->id)->first();
        if (!$user) {
            return $this->error('请先注册!', [], 1001);
        }
        $token = auth('api')->login($user);
        $data = $usersModel->respondWithToken($user, $token);
        return $this->success('登录成功', $data);
    }
    
    public function ts(Request $request) {
        
        
        
        // $signature = $this->request->signature;
        // $timestamp = $this->request->timestamp;
        // $nonce = $this->request->nonce;
        // $echostr = $this->request->echostr;
        
        $signature = $request->input('signature');
        $timestamp = $request->input('timestamp');
        $nonce = $request->input('nonce');
        $echostr = $request->input('echostr');
        $token = 'sybkfaaa';
        
        $words = array($token, $timestamp, $nonce);
        
        sort($words);
        
        $sign = $words[0].$words[1].$words[2];
        
        $sign = sha1($sign);
        
        // if($sign != $signature){
        //   return $sign; 
        // }
        
        return $echostr;
    }
    
    public function epaynotify(
        Request $request,
        OrderListModel $orderListModel) {
        
        $trade_status = $request->input('trade_status');
        
        $order_sn = $request->input('out_trade_no');
        
        $name = $request->input('name');
        
        if($trade_status == 'TRADE_SUCCESS'){
            
            $order = DB::table('order')->where('order_sn',$order_sn)->first();
            
            $jsonData = json_decode($order->data, true);
            
            if($order->type == '1') {
                
                DB::table('order')->where('order_sn',$order_sn)->update(['status'=>'1' , 'pay_time'=>time()]);
                
            }else{
                
                DB::table('order_list')->where('id',$jsonData['order_list_id'])->update(['status' => 1]);
                
            }
            
            return '支付成功，返回自动开奖'.$order->type;
        }else {
            return 'err';
        }
        
        
    }
    
    public function cxorder(Request $request) {
        
        // $order_sn = $this->request->order_sn;
        
        $order_sn = $request->input('order_sn');
        
        $order = DB::table('order')->where('order_sn',$order_sn)->first();
        
        if($order->status == 1){
            
            $order->data = json_decode($order->data, true);
            
            $user = DB::table('users')->where('id',$order->user_id)->first();
            
            $boxModel = new BoxModel();
            
            $lotteryRes = $boxModel->notify($order, $user);
        }
        
        return $this->success('请求成功', $order);
    }
    
    public function curlHttp($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $output = curl_exec($ch);
        //释放curl句柄
        curl_close($ch);
        return json_decode($output, true);
    }
    
    public function curl_post_https($url, $data, $header = [])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $output = curl_exec($ch);
        curl_close($ch);


        return $output;
    }
    
    private function getSign($param){
		ksort($param);
		reset($param);
		$signstr = '';
	
		foreach($param as $k => $v){
			if($k != "sign" && $k != "sign_type" && $v!=''){
				$signstr .= $k.'='.$v.'&';
			}
		}
		$signstr = substr($signstr,0,-1);
		$signstr .= $this->key;
		$sign = md5($signstr);
		return $sign;
	}
    
    public function Messagepost(Request $request)
    {
        $price = $request->input('price');
        
        $order_sn = $request->input('order_sn');
        
        $type = $request->input('type');
        
        if($type == 1){
            
            $goodsname = '快递运费';
            
        }else{
            
            $goodsname = '游戏充值';
            
        }
        
        $user = auth('api')->user();
        
        $order = DB::table('order')->where('user_id',$user->id)->first();
        
        $url="https://gbk.4514.cn/mapi.php";
        

        $signsz = array(
                'pid' => '1000',
                'type' => "wxpay",
                'out_trade_no' => $order_sn,
                'notify_url' => "https://mh1.yichangbingyi.top/api/v1/user/epaynotify",
                'return_url' => "https://mh1.yichangbingyi.top/api/v1/user/epaynotify",
                'name' => $goodsname,
                'money' => $price,
                'clientip' => '192.168.1.100',
                'device' => 'wechat'
            );
	
	    ksort($signsz);
	    
		reset($signsz);
		
		$signstr = '';
	
		foreach($signsz as $k => $v){
			$signstr .= $k.'='.$v.'&';
		}
		
		$signstr = substr($signstr,0,-1);
		$signstr .= 'eASyHabA4h0134041AS1e4sHagae42HA'; //易支付密钥
		$sign = md5($signstr);
        
        $data = array(
                'pid' => '1000',
                'type' => "wxpay",
                'out_trade_no' => $order_sn,
                'notify_url' => "https://mh1.yichangbingyi.top/api/v1/user/epaynotify",
                'return_url' => "https://mh1.yichangbingyi.top/api/v1/user/epaynotify",
                'name' => $goodsname,
                'money' => $price,
                'param' => "",
                'sign' => $sign,
                'sign_type' => "MD5",
                'clientip' => '192.168.1.100',
                'device' => 'wechat'
            );
        
        $result = $this->curl_post_https($url,$data);
        
        $result = json_decode($result,true);
        
        $this->sendCustomMessage($result['payurl'],$price);

        return $this->success('下单成功', $result);
    }
    
    public function get_access_token()
    {
            $appid = $this->appid ;//	小程序appidd
            $secret =  $this->appsecret;   //  小程序appsecret
            $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$appid&secret=$secret";
            $user_obj = $this->curlHttp($url);
            return $user_obj['access_token'];

    }
    
    public function sendCustomMessage($yzfurl,$price) {
        $user = auth('api')->user();
        $users = DB::table('users')->where('id',$user->id)->first();
            // $appid = $this->appid ;//	小程序appidd
            // $secret =  $this->appsecret;   //  小程序appsecret
            // $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$appid&secret=$secret";
            // $user_obj = $this->curlHttp($url);
        $access_token = $this->token;    
            
        $url="https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={$access_token}";
        
        $data_template = [
                 "content" => "您的订单金额" .$price."\n\n\n<a href='$yzfurl'>点击进行支付~~</a>",
                 ];
        
        $data = [
                'touser' => $users->openid,
                'msgtype' => "text",
                'text' => $data_template
            ];
        
        $data = json_encode($data,JSON_UNESCAPED_UNICODE);
        
        $result = $this->curl_post_https($url,$data);
        
        return $result;
    }
}
